/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherState;
import org.elasticsearch.xpack.watcher.execution.QueuedWatch;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionSnapshot;

public class OldWatcherStatsResponse
extends ActionResponse
implements ToXContentObject {
    private long watchesCount;
    private WatcherState watcherState;
    private long threadPoolQueueSize;
    private long threadPoolMaxSize;
    private WatcherMetaData watcherMetaData;
    private List<WatchExecutionSnapshot> snapshots;
    private List<QueuedWatch> queuedWatches;

    OldWatcherStatsResponse() {
    }

    public long getThreadPoolQueueSize() {
        return this.threadPoolQueueSize;
    }

    void setThreadPoolQueueSize(long threadPoolQueueSize) {
        this.threadPoolQueueSize = threadPoolQueueSize;
    }

    public long getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    void setThreadPoolMaxSize(long threadPoolMaxSize) {
        this.threadPoolMaxSize = threadPoolMaxSize;
    }

    public long getWatchesCount() {
        return this.watchesCount;
    }

    void setWatchesCount(long watchesCount) {
        this.watchesCount = watchesCount;
    }

    public WatcherState getWatcherState() {
        return this.watcherState;
    }

    void setWatcherState(WatcherState watcherServiceState) {
        this.watcherState = watcherServiceState;
    }

    @Nullable
    public List<WatchExecutionSnapshot> getSnapshots() {
        return this.snapshots;
    }

    void setSnapshots(List<WatchExecutionSnapshot> snapshots) {
        this.snapshots = snapshots;
    }

    @Nullable
    public List<QueuedWatch> getQueuedWatches() {
        return this.queuedWatches;
    }

    public void setQueuedWatches(List<QueuedWatch> queuedWatches) {
        this.queuedWatches = queuedWatches;
    }

    public WatcherMetaData getWatcherMetaData() {
        return this.watcherMetaData;
    }

    public void setWatcherMetaData(WatcherMetaData watcherMetaData) {
        this.watcherMetaData = watcherMetaData;
    }

    public void readFrom(StreamInput in) throws IOException {
        int i;
        int size;
        super.readFrom(in);
        this.watchesCount = in.readLong();
        this.threadPoolQueueSize = in.readLong();
        this.threadPoolMaxSize = in.readLong();
        this.watcherState = WatcherState.fromId(in.readByte());
        if (in.readBoolean()) {
            size = in.readVInt();
            this.snapshots = new ArrayList<WatchExecutionSnapshot>(size);
            for (i = 0; i < size; ++i) {
                WatchExecutionSnapshot snapshot = new WatchExecutionSnapshot();
                snapshot.readFrom(in);
                this.snapshots.add(snapshot);
            }
        }
        if (in.readBoolean()) {
            size = in.readVInt();
            this.queuedWatches = new ArrayList<QueuedWatch>(size);
            for (i = 0; i < size; ++i) {
                QueuedWatch queuedWatch = new QueuedWatch();
                queuedWatch.readFrom(in);
                this.queuedWatches.add(queuedWatch);
            }
        }
        this.watcherMetaData = new WatcherMetaData(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.watchesCount);
        out.writeLong(this.threadPoolQueueSize);
        out.writeLong(this.threadPoolMaxSize);
        out.writeByte(this.watcherState.getId());
        if (this.snapshots != null) {
            out.writeBoolean(true);
            out.writeVInt(this.snapshots.size());
            for (WatchExecutionSnapshot snapshot : this.snapshots) {
                snapshot.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        if (this.queuedWatches != null) {
            out.writeBoolean(true);
            out.writeVInt(this.queuedWatches.size());
            for (QueuedWatch pending : this.queuedWatches) {
                pending.writeTo(out);
            }
        } else {
            out.writeBoolean(false);
        }
        this.watcherMetaData.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("watcher_state", this.watcherState.toString().toLowerCase(Locale.ROOT));
        builder.field("watch_count", this.watchesCount);
        builder.startObject("execution_thread_pool");
        builder.field("queue_size", this.threadPoolQueueSize);
        builder.field("max_size", this.threadPoolMaxSize);
        builder.endObject();
        if (this.snapshots != null) {
            builder.startArray("current_watches");
            for (WatchExecutionSnapshot snapshot : this.snapshots) {
                snapshot.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.queuedWatches != null) {
            builder.startArray("queued_watches");
            for (QueuedWatch queuedWatch : this.queuedWatches) {
                queuedWatch.toXContent(builder, params);
            }
            builder.endArray();
        }
        this.watcherMetaData.toXContent(builder, params);
        builder.endObject();
        return builder;
    }
}

