/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.service;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.watcher.transport.actions.service.WatcherServiceResponse;

public class TransportWatcherServiceAction
extends TransportMasterNodeAction<WatcherServiceRequest, WatcherServiceResponse> {
    private AckedRequest ackedRequest = new AckedRequest(){

        public TimeValue ackTimeout() {
            return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
        }

        public TimeValue masterNodeTimeout() {
            return AcknowledgedRequest.DEFAULT_ACK_TIMEOUT;
        }
    };

    @Inject
    public TransportWatcherServiceAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/xpack/watcher/service", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, WatcherServiceRequest::new);
    }

    protected String executor() {
        return "management";
    }

    protected WatcherServiceResponse newResponse() {
        return new WatcherServiceResponse();
    }

    protected void masterOperation(WatcherServiceRequest request, ClusterState state, ActionListener<WatcherServiceResponse> listener) throws Exception {
        switch (request.getCommand()) {
            case STOP: {
                this.setWatcherMetaDataAndWait(true, listener);
                break;
            }
            case START: {
                this.setWatcherMetaDataAndWait(false, listener);
            }
        }
    }

    private void setWatcherMetaDataAndWait(final boolean manuallyStopped, final ActionListener<WatcherServiceResponse> listener) {
        String source = manuallyStopped ? "update_watcher_manually_stopped" : "update_watcher_manually_started";
        this.clusterService.submitStateUpdateTask(source, (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>(this.ackedRequest, ActionListener.wrap(b -> listener.onResponse((Object)new WatcherServiceResponse(true)), arg_0 -> listener.onFailure(arg_0))){

            protected Boolean newResponse(boolean result) {
                return result;
            }

            public ClusterState execute(ClusterState clusterState) throws Exception {
                ClusterState.Builder builder = new ClusterState.Builder(clusterState);
                builder.metaData(MetaData.builder((MetaData)clusterState.getMetaData()).putCustom("watcher", (MetaData.Custom)new WatcherMetaData(manuallyStopped)));
                return builder.build();
            }

            public void onFailure(String source, Exception throwable) {
                listener.onFailure(throwable);
            }
        });
    }

    protected ClusterBlockException checkBlock(WatcherServiceRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

