/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.put;

import java.time.Clock;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.put.PutWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.put.PutWatchResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportPutWatchAction
extends WatcherTransportAction<PutWatchRequest, PutWatchResponse> {
    private final Clock clock;
    private final Watch.Parser parser;
    private final TriggerService triggerService;
    private final Client client;

    @Inject
    public TransportPutWatchAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Clock clock, XPackLicenseState licenseState, Watch.Parser parser, Client client, ClusterService clusterService, TriggerService triggerService) {
        super(settings, "cluster:admin/xpack/watcher/watch/put", transportService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, clusterService, PutWatchRequest::new, PutWatchResponse::new);
        this.clock = clock;
        this.parser = parser;
        this.client = client;
        this.triggerService = triggerService;
    }

    @Override
    protected void masterOperation(PutWatchRequest request, ClusterState state, ActionListener<PutWatchResponse> listener) throws Exception {
        try {
            DateTime now = new DateTime(this.clock.millis(), DateTimeZone.UTC);
            Watch watch = this.parser.parseWithSecrets(request.getId(), false, request.getSource(), now, request.xContentType());
            watch.setState(request.isActive(), now);
            Map<String, String> filteredHeaders = this.threadPool.getThreadContext().getHeaders().entrySet().stream().filter(e -> Watcher.HEADER_FILTERS.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            watch.status().setHeaders(filteredHeaders);
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                WatcherParams params = WatcherParams.builder().hideSecrets(false).hideHeaders(false).put("include_status", "true").build();
                watch.toXContent(builder, (ToXContent.Params)params);
                BytesReference bytesReference = builder.bytes();
                IndexRequest indexRequest = new IndexRequest(".watches").type("doc").id(request.getId());
                indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                indexRequest.source(bytesReference, XContentType.JSON);
                ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", indexRequest, ActionListener.wrap(indexResponse -> {
                    boolean created;
                    boolean bl = created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    if (!this.localExecute(request) && watch.status().state().isActive()) {
                        this.triggerService.add(watch);
                    }
                    listener.onResponse((Object)new PutWatchResponse(indexResponse.getId(), indexResponse.getVersion(), created));
                }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
            }
        }
        catch (Exception e2) {
            listener.onFailure(e2);
        }
    }
}

