/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transport.actions.execute;

import java.io.IOException;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.watcher.condition.AlwaysCondition;
import org.elasticsearch.xpack.watcher.execution.ActionExecutionMode;
import org.elasticsearch.xpack.watcher.execution.ExecutionService;
import org.elasticsearch.xpack.watcher.execution.ManualExecutionContext;
import org.elasticsearch.xpack.watcher.history.WatchRecord;
import org.elasticsearch.xpack.watcher.input.simple.SimpleInput;
import org.elasticsearch.xpack.watcher.support.xcontent.WatcherParams;
import org.elasticsearch.xpack.watcher.transport.actions.WatcherTransportAction;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.watcher.trigger.TriggerEvent;
import org.elasticsearch.xpack.watcher.trigger.TriggerService;
import org.elasticsearch.xpack.watcher.trigger.manual.ManualTriggerEvent;
import org.elasticsearch.xpack.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.watch.Watch;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class TransportExecuteWatchAction
extends WatcherTransportAction<ExecuteWatchRequest, ExecuteWatchResponse> {
    private final ExecutionService executionService;
    private final Clock clock;
    private final TriggerService triggerService;
    private final Watch.Parser watchParser;
    private final Client client;

    @Inject
    public TransportExecuteWatchAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ExecutionService executionService, Clock clock, XPackLicenseState licenseState, Watch.Parser watchParser, Client client, TriggerService triggerService, ClusterService clusterService) {
        super(settings, "cluster:admin/xpack/watcher/watch/execute", transportService, threadPool, actionFilters, indexNameExpressionResolver, licenseState, clusterService, ExecuteWatchRequest::new, ExecuteWatchResponse::new);
        this.executionService = executionService;
        this.clock = clock;
        this.triggerService = triggerService;
        this.watchParser = watchParser;
        this.client = client;
    }

    @Override
    protected void masterOperation(ExecuteWatchRequest request, ClusterState state, ActionListener<ExecuteWatchResponse> listener) throws Exception {
        if (request.getId() != null) {
            GetRequest getRequest = new GetRequest(".watches", "doc", request.getId()).preference(Preference.LOCAL.type()).realtime(true);
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "watcher", getRequest, ActionListener.wrap(response -> {
                if (response.isExists()) {
                    Watch watch = this.watchParser.parse(request.getId(), true, response.getSourceAsBytesRef(), request.getXContentType());
                    watch.version(response.getVersion());
                    watch.status().version(response.getVersion());
                    this.executeWatch(request, listener, watch, true);
                } else {
                    listener.onFailure((Exception)((Object)new ResourceNotFoundException("Watch with id [{}] does not exist", new Object[]{request.getId()})));
                }
            }, arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
        } else if (request.getWatchSource() != null) {
            try {
                assert (!request.isRecordExecution());
                Watch watch = this.watchParser.parse("_inlined_", true, request.getWatchSource(), request.getXContentType());
                this.executeWatch(request, listener, watch, false);
            }
            catch (IOException e) {
                this.logger.error((Message)new ParameterizedMessage("failed to parse [{}]", (Object)request.getId()), (Throwable)e);
                listener.onFailure((Exception)e);
            }
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("no watch provided"));
        }
    }

    private void executeWatch(final ExecuteWatchRequest request, final ActionListener<ExecuteWatchResponse> listener, final Watch watch, final boolean knownWatch) {
        this.threadPool.executor("watcher").submit((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            protected void doRun() throws Exception {
                try {
                    HashMap<String, String> headers = new HashMap<String, String>(TransportExecuteWatchAction.this.threadPool.getThreadContext().getHeaders());
                    watch.status().setHeaders(headers);
                    String triggerType = watch.trigger().type();
                    TriggerEvent triggerEvent = TransportExecuteWatchAction.this.triggerService.simulateEvent(triggerType, watch.id(), request.getTriggerData());
                    ManualExecutionContext.Builder ctxBuilder = ManualExecutionContext.builder(watch, knownWatch, new ManualTriggerEvent(triggerEvent.jobName(), triggerEvent), TransportExecuteWatchAction.this.executionService.defaultThrottlePeriod());
                    DateTime executionTime = new DateTime(TransportExecuteWatchAction.this.clock.millis(), DateTimeZone.UTC);
                    ctxBuilder.executionTime(executionTime);
                    for (Map.Entry<String, ActionExecutionMode> entry : request.getActionModes().entrySet()) {
                        ctxBuilder.actionMode(entry.getKey(), entry.getValue());
                    }
                    if (request.getAlternativeInput() != null) {
                        ctxBuilder.withInput(new SimpleInput.Result(new Payload.Simple(request.getAlternativeInput())));
                    }
                    if (request.isIgnoreCondition()) {
                        ctxBuilder.withCondition(AlwaysCondition.RESULT_INSTANCE);
                    }
                    ctxBuilder.recordExecution(request.isRecordExecution());
                    WatchRecord record = TransportExecuteWatchAction.this.executionService.execute(ctxBuilder.build());
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    record.toXContent(builder, (ToXContent.Params)WatcherParams.builder().hideSecrets(true).debug(request.isDebug()).build());
                    listener.onResponse((Object)new ExecuteWatchResponse(record.id().value(), builder.bytes(), XContentType.JSON));
                }
                catch (IOException e) {
                    listener.onFailure((Exception)e);
                }
            }
        });
    }
}

