/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.watcher.transform.TransformFactory;
import org.elasticsearch.xpack.watcher.transform.script.ExecutableScriptTransform;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;

public class ScriptTransformFactory
extends TransformFactory<ScriptTransform, ScriptTransform.Result, ExecutableScriptTransform> {
    private final ScriptService scriptService;

    public ScriptTransformFactory(Settings settings, ScriptService scriptService) {
        super(Loggers.getLogger(ExecutableScriptTransform.class, (Settings)settings, (String[])new String[0]));
        this.scriptService = scriptService;
    }

    @Override
    public String type() {
        return "script";
    }

    @Override
    public ScriptTransform parseTransform(String watchId, XContentParser parser) throws IOException {
        return ScriptTransform.parse(watchId, parser);
    }

    @Override
    public ExecutableScriptTransform createExecutable(ScriptTransform transform) {
        return new ExecutableScriptTransform(transform, this.transformLogger, this.scriptService);
    }
}

