/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.transform.script;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xpack.watcher.Watcher;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.transform.ExecutableTransform;
import org.elasticsearch.xpack.watcher.transform.script.ScriptTransform;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableScriptTransform
extends ExecutableTransform<ScriptTransform, ScriptTransform.Result> {
    private final ScriptService scriptService;

    public ExecutableScriptTransform(ScriptTransform transform, Logger logger, ScriptService scriptService) {
        super(transform, logger);
        this.scriptService = scriptService;
        Script script = transform.getScript();
        scriptService.compile(script, Watcher.SCRIPT_EXECUTABLE_CONTEXT);
    }

    @Override
    public ScriptTransform.Result execute(WatchExecutionContext ctx, Payload payload) {
        try {
            return this.doExecute(ctx, payload);
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("failed to execute [{}] transform for [{}]", (Object)"script", (Object)ctx.id()), (Throwable)e);
            return new ScriptTransform.Result(e);
        }
    }

    ScriptTransform.Result doExecute(WatchExecutionContext ctx, Payload payload) throws IOException {
        Script script = ((ScriptTransform)this.transform).getScript();
        HashMap<String, Object> model = new HashMap<String, Object>();
        if (script.getParams() != null) {
            model.putAll(script.getParams());
        }
        model.putAll(Variables.createCtxModel(ctx, payload));
        ExecutableScript.Factory factory = (ExecutableScript.Factory)this.scriptService.compile(script, Watcher.SCRIPT_EXECUTABLE_CONTEXT);
        ExecutableScript executable = factory.newInstance(model);
        Object value = executable.run();
        if (value instanceof Map) {
            return new ScriptTransform.Result(new Payload.Simple((Map)value));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_value", value);
        return new ScriptTransform.Result(new Payload.Simple(data));
    }
}

