/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.condition;

import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.watcher.condition.AbstractCompareCondition;
import org.elasticsearch.xpack.watcher.condition.Condition;
import org.elasticsearch.xpack.watcher.condition.LenientCompare;
import org.elasticsearch.xpack.watcher.support.xcontent.ObjectPath;

public final class ArrayCompareCondition
extends AbstractCompareCondition {
    public static final String TYPE = "array_compare";
    private final String arrayPath;
    private final String path;
    private final Op op;
    private final Object value;
    private final Quantifier quantifier;

    ArrayCompareCondition(String arrayPath, String path, Op op, Object value, Quantifier quantifier, Clock clock) {
        super(TYPE, clock);
        this.arrayPath = arrayPath;
        this.path = path;
        this.op = op;
        this.value = value;
        this.quantifier = quantifier;
    }

    public String getArrayPath() {
        return this.arrayPath;
    }

    public String getPath() {
        return this.path;
    }

    public Op getOp() {
        return this.op;
    }

    public Object getValue() {
        return this.value;
    }

    public Quantifier getQuantifier() {
        return this.quantifier;
    }

    public static Condition parse(Clock clock, String watchId, XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object but found [{}] instead", new Object[]{TYPE, watchId, parser.currentToken()});
        }
        String arrayPath = null;
        String path = null;
        Op op = null;
        Object value = null;
        boolean haveValue = false;
        Quantifier quantifier = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                arrayPath = parser.currentName();
                continue;
            }
            if (arrayPath == null) {
                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path, but found [{}] instead", new Object[]{TYPE, watchId, token});
            }
            if (token == XContentParser.Token.START_OBJECT) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        if (parser.currentName().equals("path")) {
                            parser.nextToken();
                            path = parser.text();
                            continue;
                        }
                        if (op != null) {
                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate comparison operator, but already saw [{}].", new Object[]{TYPE, watchId, parser.currentName(), op.id()});
                        }
                        try {
                            op = Op.resolve(parser.currentName());
                        }
                        catch (IllegalArgumentException iae) {
                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison operator [{}]", new Object[]{TYPE, watchId, parser.currentName(), iae});
                        }
                        token = parser.nextToken();
                        if (token == XContentParser.Token.START_OBJECT) {
                            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                                if (token == XContentParser.Token.FIELD_NAME) {
                                    if (parser.currentName().equals("value")) {
                                        if (haveValue) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate field \"value\", but already saw value [{}].", new Object[]{TYPE, watchId, value});
                                        }
                                        token = parser.nextToken();
                                        if (!op.supportsStructures() && !token.isValue() && token != XContentParser.Token.VALUE_NULL) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. compared value for [{}] with operation [{}] must either be a numeric, string, boolean or null value, but found [{}] instead", new Object[]{TYPE, watchId, path, op.name().toLowerCase(Locale.ROOT), token});
                                        }
                                        value = XContentUtils.readValue(parser, token);
                                        haveValue = true;
                                        continue;
                                    }
                                    if (parser.currentName().equals("quantifier")) {
                                        if (quantifier != null) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. encountered duplicate field \"quantifier\", but already saw quantifier [{}].", new Object[]{TYPE, watchId, quantifier.id()});
                                        }
                                        parser.nextToken();
                                        try {
                                            quantifier = Quantifier.resolve(parser.text());
                                            continue;
                                        }
                                        catch (IllegalArgumentException iae) {
                                            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. unknown comparison quantifier [{}]", new Object[]{TYPE, watchId, parser.text(), iae});
                                        }
                                    }
                                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison value or comparison quantifier, but found [{}] instead", new Object[]{TYPE, watchId, parser.currentName()});
                                }
                                throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the comparison value or comparison quantifier, but found [{}] instead", new Object[]{TYPE, watchId, token});
                            }
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, op.id(), token});
                    }
                    throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected a field indicating the compared path or a comparison operator, but found [{}] instead", new Object[]{TYPE, watchId, token});
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse [{}] condition for watch [{}]. expected an object for field [{}] but found [{}] instead", new Object[]{TYPE, watchId, path, token});
        }
        if (path == null) {
            path = "";
        }
        if (quantifier == null) {
            quantifier = Quantifier.SOME;
        }
        return new ArrayCompareCondition(arrayPath, path, op, value, quantifier, clock);
    }

    @Override
    public Condition.Result doExecute(Map<String, Object> model, Map<String, Object> resolvedValues) {
        Object configuredValue = this.resolveConfiguredValue(resolvedValues, model, this.value);
        Object object = ObjectPath.eval(this.arrayPath, model);
        if (object != null && !(object instanceof List)) {
            throw new IllegalStateException("array path " + this.arrayPath + " did not evaluate to array, was " + object);
        }
        List resolvedArray = object != null ? (List)object : Collections.emptyList();
        ArrayList<Object> resolvedValue = new ArrayList<Object>(resolvedArray.size());
        for (int i = 0; i < resolvedArray.size(); ++i) {
            resolvedValue.add(ObjectPath.eval(this.path, resolvedArray.get(i)));
        }
        resolvedValues.put(this.arrayPath, resolvedArray);
        return new Condition.Result(resolvedValues, TYPE, this.quantifier.eval(resolvedValue, configuredValue, this.op));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayCompareCondition that = (ArrayCompareCondition)o;
        return Objects.equals(this.getArrayPath(), that.getArrayPath()) && Objects.equals(this.getPath(), that.getPath()) && Objects.equals((Object)this.getOp(), (Object)that.getOp()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals((Object)this.getQuantifier(), (Object)that.getQuantifier());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.arrayPath, this.path, this.op, this.value, this.quantifier});
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().startObject(this.arrayPath).field("path", this.path).startObject(this.op.id()).field("value", this.value).field("quantifier", this.quantifier.id()).endObject().endObject().endObject();
    }

    public static enum Quantifier {
        ALL{

            @Override
            public boolean eval(List<Object> values, Object configuredValue, Op op) {
                for (Object value : values) {
                    Integer compare = LenientCompare.compare(value, configuredValue);
                    boolean comparison = compare != null && op.comparison(compare);
                    if (comparison) continue;
                    return false;
                }
                return true;
            }
        }
        ,
        SOME{

            @Override
            public boolean eval(List<Object> values, Object configuredValue, Op op) {
                for (Object value : values) {
                    Integer compare = LenientCompare.compare(value, configuredValue);
                    boolean comparison = compare != null && op.comparison(compare);
                    if (!comparison) continue;
                    return true;
                }
                return false;
            }
        };


        public abstract boolean eval(List<Object> var1, Object var2, Op var3);

        public static Quantifier resolve(String id) {
            return Quantifier.valueOf(id.toUpperCase(Locale.ROOT));
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum Op {
        EQ{

            @Override
            public boolean comparison(int x) {
                return x == 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        NOT_EQ{

            @Override
            public boolean comparison(int x) {
                return x != 0;
            }

            @Override
            public boolean supportsStructures() {
                return true;
            }
        }
        ,
        GTE{

            @Override
            public boolean comparison(int x) {
                return x >= 0;
            }
        }
        ,
        GT{

            @Override
            public boolean comparison(int x) {
                return x > 0;
            }
        }
        ,
        LTE{

            @Override
            public boolean comparison(int x) {
                return x <= 0;
            }
        }
        ,
        LT{

            @Override
            public boolean comparison(int x) {
                return x < 0;
            }
        };


        public abstract boolean comparison(int var1);

        public boolean supportsStructures() {
            return false;
        }

        public String id() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static Op resolve(String id) {
            return Op.valueOf(id.toUpperCase(Locale.ROOT));
        }
    }
}

