/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.throttler;

import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;

public interface Throttler {
    public Result throttle(String var1, WatchExecutionContext var2);

    public static interface Field {
        public static final ParseField THROTTLE_PERIOD = new ParseField("throttle_period_in_millis", new String[0]);
        public static final ParseField THROTTLE_PERIOD_HUMAN = new ParseField("throttle_period", new String[0]);
    }

    public static class Result {
        public static final Result NO = new Result(Type.NONE, false, null);
        private Type type;
        private final boolean throttle;
        private final String reason;

        private Result(Type type, boolean throttle, String reason) {
            this.type = type;
            this.throttle = throttle;
            this.reason = reason;
        }

        public static Result throttle(Type type, String reason, Object ... args) {
            return new Result(type, true, LoggerMessageFormat.format((String)reason, (Object[])args));
        }

        public boolean throttle() {
            return this.throttle;
        }

        public String reason() {
            return this.reason;
        }

        public Type type() {
            return this.type;
        }
    }

    public static enum Type {
        ACK,
        LICENSE,
        PERIOD,
        NONE;

    }
}

