/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.index;

import java.io.IOException;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.index.ExecutableIndexAction;
import org.elasticsearch.xpack.watcher.actions.index.IndexAction;

public class IndexActionFactory
extends ActionFactory {
    private final Client client;
    private final TimeValue indexDefaultTimeout;
    private final TimeValue bulkDefaultTimeout;

    public IndexActionFactory(Settings settings, Client client) {
        super(Loggers.getLogger(IndexActionFactory.class, (Settings)settings, (String[])new String[0]));
        this.client = client;
        this.indexDefaultTimeout = settings.getAsTime("xpack.watcher.actions.index.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.bulkDefaultTimeout = settings.getAsTime("xpack.watcher.actions.bulk.default_timeout", TimeValue.timeValueMinutes((long)1L));
    }

    @Override
    public ExecutableIndexAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        return new ExecutableIndexAction(IndexAction.parse(watchId, actionId, parser), this.actionLogger, this.client, this.indexDefaultTimeout, this.bulkDefaultTimeout);
    }
}

