/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.email;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.email.Attachment;
import org.elasticsearch.xpack.notification.email.DataAttachment;
import org.elasticsearch.xpack.notification.email.Email;
import org.elasticsearch.xpack.notification.email.EmailService;
import org.elasticsearch.xpack.notification.email.HtmlSanitizer;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.actions.Action;
import org.elasticsearch.xpack.watcher.actions.ExecutableAction;
import org.elasticsearch.xpack.watcher.actions.email.EmailAction;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class ExecutableEmailAction
extends ExecutableAction<EmailAction> {
    private final EmailService emailService;
    private final TextTemplateEngine templateEngine;
    private final HtmlSanitizer htmlSanitizer;
    private final Map<String, EmailAttachmentParser> emailAttachmentParsers;

    public ExecutableEmailAction(EmailAction action, Logger logger, EmailService emailService, TextTemplateEngine templateEngine, HtmlSanitizer htmlSanitizer, Map<String, EmailAttachmentParser> emailAttachmentParsers) {
        super(action, logger);
        this.emailService = emailService;
        this.templateEngine = templateEngine;
        this.htmlSanitizer = htmlSanitizer;
        this.emailAttachmentParsers = emailAttachmentParsers;
    }

    @Override
    public Action.Result execute(String actionId, WatchExecutionContext ctx, Payload payload) throws Exception {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        HashMap<String, Attachment> attachments = new HashMap<String, Attachment>();
        DataAttachment dataAttachment = ((EmailAction)this.action).getDataAttachment();
        if (dataAttachment != null) {
            Attachment attachment = dataAttachment.create("data", model);
            attachments.put(attachment.id(), attachment);
        }
        if (((EmailAction)this.action).getAttachments() != null && ((EmailAction)this.action).getAttachments().getAttachments().size() > 0) {
            for (EmailAttachmentParser.EmailAttachment emailAttachment : ((EmailAction)this.action).getAttachments().getAttachments()) {
                EmailAttachmentParser parser = this.emailAttachmentParsers.get(emailAttachment.type());
                try {
                    Attachment attachment = parser.toAttachment(ctx, payload, emailAttachment);
                    attachments.put(attachment.id(), attachment);
                }
                catch (IOException | ElasticsearchException e) {
                    return new Action.Result.FailureWithException(((EmailAction)this.action).type(), (Exception)e);
                }
            }
        }
        Email.Builder email = ((EmailAction)this.action).getEmail().render(this.templateEngine, model, this.htmlSanitizer, attachments);
        email.id(ctx.id().value());
        if (ctx.simulateAction(actionId)) {
            return new EmailAction.Result.Simulated(email.build());
        }
        EmailService.EmailSent sent = this.emailService.send(email.build(), ((EmailAction)this.action).getAuth(), ((EmailAction)this.action).getProfile(), ((EmailAction)this.action).getAccount());
        return new EmailAction.Result.Success(sent.account(), sent.email());
    }
}

