/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.actions.email;

import java.io.IOException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.notification.email.EmailService;
import org.elasticsearch.xpack.notification.email.HtmlSanitizer;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentsParser;
import org.elasticsearch.xpack.watcher.actions.ActionFactory;
import org.elasticsearch.xpack.watcher.actions.email.EmailAction;
import org.elasticsearch.xpack.watcher.actions.email.ExecutableEmailAction;

public class EmailActionFactory
extends ActionFactory {
    private final EmailService emailService;
    private final TextTemplateEngine templateEngine;
    private final HtmlSanitizer htmlSanitizer;
    private final EmailAttachmentsParser emailAttachmentsParser;

    public EmailActionFactory(Settings settings, EmailService emailService, TextTemplateEngine templateEngine, EmailAttachmentsParser emailAttachmentsParser) {
        super(Loggers.getLogger(ExecutableEmailAction.class, (Settings)settings, (String[])new String[0]));
        this.emailService = emailService;
        this.templateEngine = templateEngine;
        this.htmlSanitizer = new HtmlSanitizer(settings);
        this.emailAttachmentsParser = emailAttachmentsParser;
    }

    @Override
    public ExecutableEmailAction parseExecutable(String watchId, String actionId, XContentParser parser) throws IOException {
        return new ExecutableEmailAction(EmailAction.parse(watchId, actionId, parser, this.emailAttachmentsParser), this.actionLogger, this.emailService, this.templateEngine, this.htmlSanitizer, this.emailAttachmentsParser.getParsers());
    }
}

