/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.AllocationId;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.upgrade.Upgrade;
import org.elasticsearch.xpack.watcher.WatcherMetaData;
import org.elasticsearch.xpack.watcher.WatcherService;
import org.elasticsearch.xpack.watcher.WatcherState;
import org.elasticsearch.xpack.watcher.support.WatcherIndexTemplateRegistry;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class WatcherLifeCycleService
extends AbstractComponent
implements ClusterStateListener {
    private final WatcherService watcherService;
    private final ExecutorService executor;
    private AtomicReference<List<String>> previousAllocationIds = new AtomicReference(Collections.emptyList());
    private volatile WatcherMetaData watcherMetaData;

    WatcherLifeCycleService(Settings settings, ThreadPool threadPool, ClusterService clusterService, WatcherService watcherService) {
        super(settings);
        this.executor = threadPool.executor("generic");
        this.watcherService = watcherService;
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                WatcherLifeCycleService.this.stop("stopping before shutting down");
            }
        });
        this.watcherMetaData = new WatcherMetaData(settings.getAsBoolean("xpack.watcher.start_immediately", Boolean.valueOf(true)) == false);
    }

    public void stop(String reason) {
        this.watcherService.stop(reason);
    }

    private synchronized void start(ClusterState state, boolean manual) {
        WatcherState watcherState = this.watcherService.state();
        if (watcherState != WatcherState.STOPPED) {
            this.logger.debug("not starting watcher. watcher can only start if its current state is [{}], but its current state now is [{}]", (Object)WatcherState.STOPPED, (Object)watcherState);
            return;
        }
        if (!manual && this.watcherMetaData != null && this.watcherMetaData.manuallyStopped()) {
            this.logger.debug("not starting watcher. watcher was stopped manually and therefore cannot be auto-started");
            return;
        }
        if (!WatcherIndexTemplateRegistry.validate(state)) {
            this.logger.debug("not starting watcher, watcher templates are missing in the cluster state");
            return;
        }
        if (this.watcherService.validate(state)) {
            this.logger.trace("starting... (based on cluster state version [{}]) (manual [{}])", (Object)state.getVersion(), (Object)manual);
            try {
                this.watcherService.start(state);
            }
            catch (Exception e) {
                this.logger.warn("failed to start watcher. please wait for the cluster to become ready or try to start Watcher manually", (Throwable)e);
            }
        } else {
            this.logger.debug("not starting watcher. because the cluster isn't ready yet to run watcher");
        }
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean currentWatcherStopped;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        WatcherMetaData watcherMetaData = (WatcherMetaData)event.state().getMetaData().custom("watcher");
        if (watcherMetaData != null) {
            this.watcherMetaData = watcherMetaData;
        }
        boolean bl = currentWatcherStopped = watcherMetaData != null && watcherMetaData.manuallyStopped();
        if (currentWatcherStopped) {
            this.executor.execute(() -> this.stop("watcher manually marked to shutdown in cluster state update, shutting down"));
        } else {
            boolean isDistributedWatchExecutionEnabled = WatcherLifeCycleService.isWatchExecutionDistributed(event.state());
            if (isDistributedWatchExecutionEnabled) {
                if (this.watcherService.state() == WatcherState.STARTED && event.state().nodes().getLocalNode().isDataNode()) {
                    DiscoveryNode localNode = event.state().nodes().getLocalNode();
                    RoutingNode routingNode = event.state().getRoutingNodes().node(localNode.getId());
                    IndexMetaData watcherIndexMetaData = WatchStoreUtils.getConcreteIndex(".watches", event.state().metaData());
                    if (watcherIndexMetaData == null) {
                        if (!this.previousAllocationIds.get().isEmpty()) {
                            this.previousAllocationIds.set(Collections.emptyList());
                            this.executor.execute(() -> this.watcherService.pauseExecution("no watcher index found"));
                        }
                        return;
                    }
                    String watchIndex = watcherIndexMetaData.getIndex().getName();
                    List localShards = routingNode.shardsWithState(watchIndex, new ShardRoutingState[]{ShardRoutingState.RELOCATING, ShardRoutingState.STARTED});
                    if (localShards.isEmpty()) {
                        if (!this.previousAllocationIds.get().isEmpty()) {
                            this.executor.execute(() -> this.watcherService.pauseExecution("no local watcher shards"));
                            this.previousAllocationIds.set(Collections.emptyList());
                        }
                        return;
                    }
                    List currentAllocationIds = localShards.stream().map(ShardRouting::allocationId).map(AllocationId::getId).collect(Collectors.toList());
                    Collections.sort(currentAllocationIds);
                    if (!this.previousAllocationIds.get().equals(currentAllocationIds)) {
                        this.previousAllocationIds.set(currentAllocationIds);
                        this.executor.execute(() -> this.watcherService.reload(event.state(), "different shard allocation ids"));
                    }
                } else if (this.watcherService.state() != WatcherState.STARTED && this.watcherService.state() != WatcherState.STARTING) {
                    boolean isIndexInternalFormatTriggeredWatchIndex;
                    IndexMetaData watcherIndexMetaData = WatchStoreUtils.getConcreteIndex(".watches", event.state().metaData());
                    IndexMetaData triggeredWatchesIndexMetaData = WatchStoreUtils.getConcreteIndex(".triggered_watches", event.state().metaData());
                    boolean isIndexInternalFormatWatchIndex = watcherIndexMetaData == null || Upgrade.checkInternalIndexFormat(watcherIndexMetaData);
                    boolean bl2 = isIndexInternalFormatTriggeredWatchIndex = triggeredWatchesIndexMetaData == null || Upgrade.checkInternalIndexFormat(triggeredWatchesIndexMetaData);
                    if (isIndexInternalFormatTriggeredWatchIndex && isIndexInternalFormatWatchIndex) {
                        this.executor.execute(() -> this.start(event.state(), false));
                    } else {
                        this.logger.warn("not starting watcher, upgrade API run required: .watches[{}], .triggered_watches[{}]", (Object)isIndexInternalFormatWatchIndex, (Object)isIndexInternalFormatTriggeredWatchIndex);
                    }
                }
            } else if (event.localNodeMaster()) {
                if (this.watcherService.state() != WatcherState.STARTED && this.watcherService.state() != WatcherState.STARTING) {
                    this.executor.execute(() -> this.start(event.state(), false));
                }
            } else if (this.watcherService.state() == WatcherState.STARTED || this.watcherService.state() == WatcherState.STARTING) {
                this.executor.execute(() -> this.watcherService.pauseExecution("Pausing watcher, cluster contains old nodes not supporting distributed watch execution"));
            }
        }
    }

    public static boolean isWatchExecutionDistributed(ClusterState state) {
        return state.nodes().getMinNodeVersion().onOrAfter(Version.V_6_0_0_beta1);
    }

    public WatcherMetaData watcherMetaData() {
        return this.watcherMetaData;
    }
}

