/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.template;

import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static void loadTemplateIntoMap(String resource, Map<String, IndexTemplateMetaData> map, String templateName, String version, String versionProperty, Logger logger) {
        String template = TemplateUtils.loadTemplate(resource, version, versionProperty);
        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, template);){
            map.put(templateName, IndexTemplateMetaData.Builder.fromXContent((XContentParser)parser, (String)templateName));
        }
        catch (IOException e) {
            logger.error("Error loading template [{}] as part of metadata upgrading", (Object)templateName);
        }
    }

    public static String loadTemplate(String resource, String version, String versionProperty) {
        try {
            BytesReference source = TemplateUtils.load(resource);
            TemplateUtils.validate(source);
            return TemplateUtils.filter(source, version, versionProperty);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load template [" + resource + "]", e);
        }
    }

    /*
     * Exception decompiling
     */
    public static BytesReference load(String name) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void validate(BytesReference source) {
        if (source == null) {
            throw new ElasticsearchParseException("Template must not be null", new Object[0]);
        }
        try {
            XContentHelper.convertToMap((BytesReference)source, (boolean)false, (XContentType)XContentType.JSON).v2();
        }
        catch (NotXContentException e) {
            throw new ElasticsearchParseException("Template must not be empty", new Object[0]);
        }
        catch (Exception e) {
            throw new ElasticsearchParseException("Invalid template", (Throwable)e, new Object[0]);
        }
    }

    public static String filter(BytesReference source, String version, String versionProperty) {
        return Pattern.compile(versionProperty).matcher(source.utf8ToString()).replaceAll(version);
    }

    public static boolean checkTemplateExistsAndVersionIsGTECurrentVersion(String templateName, ClusterState state) {
        IndexTemplateMetaData templateMetaData = (IndexTemplateMetaData)state.metaData().templates().get((Object)templateName);
        if (templateMetaData == null) {
            return false;
        }
        return templateMetaData.version() != null && templateMetaData.version() >= Version.CURRENT.id;
    }

    public static boolean checkTemplateExistsAndIsUpToDate(String templateName, String versionKey, ClusterState state, Logger logger) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches(templateName, versionKey, state, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, String versionKey, ClusterState state, Logger logger, Predicate<Version> predicate) {
        IndexTemplateMetaData templateMeta = (IndexTemplateMetaData)state.metaData().templates().get((Object)templateName);
        if (templateMeta == null) {
            return false;
        }
        ImmutableOpenMap mappings = templateMeta.getMappings();
        for (Object typeMapping : mappings.values().toArray()) {
            CompressedXContent typeMappingXContent = (CompressedXContent)typeMapping;
            try {
                Map typeMappingMap = (Map)XContentHelper.convertToMap((BytesReference)new BytesArray(typeMappingXContent.uncompressed()), (boolean)false, (XContentType)XContentType.JSON).v2();
                assert (typeMappingMap.size() == 1);
                String key = (String)typeMappingMap.keySet().iterator().next();
                Map mappingMap = (Map)typeMappingMap.get(key);
                if (TemplateUtils.containsCorrectVersion(versionKey, mappingMap, predicate)) continue;
                return false;
            }
            catch (ElasticsearchParseException e) {
                logger.error((Message)new ParameterizedMessage("Cannot parse the template [{}]", (Object)templateName), (Throwable)e);
                throw new IllegalStateException("Cannot parse the template " + templateName, e);
            }
        }
        return true;
    }

    private static boolean containsCorrectVersion(String versionKey, Map<String, Object> typeMappingMap, Predicate<Version> predicate) {
        Map meta = (Map)typeMappingMap.get("_meta");
        if (meta == null) {
            return false;
        }
        return predicate.test(Version.fromString((String)((String)meta.get(versionKey))));
    }
}

