/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.KeyConfig;

class StoreKeyConfig
extends KeyConfig {
    final String keyStorePath;
    final String keyStoreType;
    final SecureString keyStorePassword;
    final String keyStoreAlgorithm;
    final SecureString keyPassword;
    final String trustStoreAlgorithm;

    StoreKeyConfig(String keyStorePath, String keyStoreType, SecureString keyStorePassword, SecureString keyPassword, String keyStoreAlgorithm, String trustStoreAlgorithm) {
        this.keyStorePath = Objects.requireNonNull(keyStorePath, "keystore path must be specified");
        this.keyStoreType = Objects.requireNonNull(keyStoreType, "keystore type must be specified");
        this.keyStorePassword = Objects.requireNonNull(keyStorePassword, "keystore password must be specified").clone();
        this.keyPassword = Objects.requireNonNull(keyPassword).clone();
        this.keyStoreAlgorithm = keyStoreAlgorithm;
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    @Override
    X509ExtendedKeyManager createKeyManager(@Nullable Environment environment) {
        try {
            KeyStore ks = this.getKeyStore(environment);
            this.checkKeyStore(ks);
            return CertUtils.keyManager(ks, this.keyPassword.getChars(), this.keyStoreAlgorithm);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new ElasticsearchException("failed to initialize a KeyManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(this.keyStorePath, this.keyStoreType, this.keyStorePassword.getChars(), this.trustStoreAlgorithm, environment);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.singletonList(CertUtils.resolvePath(this.keyStorePath, environment));
    }

    @Override
    List<PrivateKey> privateKeys(@Nullable Environment environment) {
        try {
            KeyStore keyStore = this.getKeyStore(environment);
            ArrayList<PrivateKey> privateKeys = new ArrayList<PrivateKey>();
            Enumeration<String> e = keyStore.aliases();
            while (e.hasMoreElements()) {
                Key key;
                String alias = e.nextElement();
                if (!keyStore.isKeyEntry(alias) || !((key = keyStore.getKey(alias, this.keyPassword.getChars())) instanceof PrivateKey)) continue;
                privateKeys.add((PrivateKey)key);
            }
            return privateKeys;
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to list keys", (Throwable)e, new Object[0]);
        }
    }

    private KeyStore getKeyStore(@Nullable Environment environment) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        try (InputStream in = Files.newInputStream(CertUtils.resolvePath(this.keyStorePath, environment), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance(this.keyStoreType);
            ks.load(in, this.keyStorePassword.getChars());
            KeyStore keyStore = ks;
            return keyStore;
        }
    }

    private void checkKeyStore(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            return;
        }
        throw new IllegalArgumentException("the keystore [" + this.keyStorePath + "] does not contain a private key entry");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreKeyConfig that = (StoreKeyConfig)o;
        if (this.keyStorePath != null ? !this.keyStorePath.equals(that.keyStorePath) : that.keyStorePath != null) {
            return false;
        }
        if (this.keyStorePassword != null ? !this.keyStorePassword.equals((Object)that.keyStorePassword) : that.keyStorePassword != null) {
            return false;
        }
        if (this.keyStoreAlgorithm != null ? !this.keyStoreAlgorithm.equals(that.keyStoreAlgorithm) : that.keyStoreAlgorithm != null) {
            return false;
        }
        if (this.keyPassword != null ? !this.keyPassword.equals((Object)that.keyPassword) : that.keyPassword != null) {
            return false;
        }
        return this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.equals(that.trustStoreAlgorithm) : that.trustStoreAlgorithm == null;
    }

    @Override
    public int hashCode() {
        int result = this.keyStorePath != null ? this.keyStorePath.hashCode() : 0;
        result = 31 * result + (this.keyStorePassword != null ? this.keyStorePassword.hashCode() : 0);
        result = 31 * result + (this.keyStoreAlgorithm != null ? this.keyStoreAlgorithm.hashCode() : 0);
        result = 31 * result + (this.keyPassword != null ? this.keyPassword.hashCode() : 0);
        result = 31 * result + (this.trustStoreAlgorithm != null ? this.trustStoreAlgorithm.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "keyStorePath=[" + this.keyStorePath + "], keyStoreType=[" + this.keyStoreType + "], keyStoreAlgorithm=[" + this.keyStoreAlgorithm + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

