/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.CertificateTrustRestrictions;
import org.elasticsearch.xpack.ssl.RestrictedTrustManager;
import org.elasticsearch.xpack.ssl.TrustConfig;

public final class RestrictedTrustConfig
extends TrustConfig {
    private static final String RESTRICTIONS_KEY_SUBJECT_NAME = "trust.subject_name";
    private final Settings settings;
    private final String groupConfigPath;
    private final TrustConfig delegate;

    RestrictedTrustConfig(Settings settings, String groupConfigPath, TrustConfig delegate) {
        this.settings = settings;
        this.groupConfigPath = Objects.requireNonNull(groupConfigPath);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    RestrictedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            X509ExtendedTrustManager delegateTrustManager = this.delegate.createTrustManager(environment);
            CertificateTrustRestrictions trustGroupConfig = this.readTrustGroup(this.resolveGroupConfigPath(environment));
            return new RestrictedTrustManager(this.settings, delegateTrustManager, trustGroupConfig);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to initialize TrustManager for {}", (Throwable)e, new Object[]{this.toString()});
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        ArrayList<Path> files = new ArrayList<Path>(this.delegate.filesToMonitor(environment));
        files.add(this.resolveGroupConfigPath(environment));
        return Collections.unmodifiableList(files);
    }

    @Override
    public String toString() {
        return "restrictedTrust=[" + this.groupConfigPath + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedTrustConfig that = (RestrictedTrustConfig)o;
        return this.groupConfigPath.equals(that.groupConfigPath) && this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        int result = this.groupConfigPath.hashCode();
        result = 31 * result + this.delegate.hashCode();
        return result;
    }

    private Path resolveGroupConfigPath(@Nullable Environment environment) {
        return CertUtils.resolvePath(this.groupConfigPath, environment);
    }

    private CertificateTrustRestrictions readTrustGroup(Path path) throws IOException {
        Settings settings = Settings.builder().loadFromPath(path).build();
        List trustNodeNames = settings.getAsList(RESTRICTIONS_KEY_SUBJECT_NAME);
        return new CertificateTrustRestrictions(trustNodeNames);
    }
}

