/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ssl;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.TrustConfig;

class DefaultJDKTrustConfig
extends TrustConfig {
    static final DefaultJDKTrustConfig INSTANCE = new DefaultJDKTrustConfig();

    private DefaultJDKTrustConfig() {
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        try {
            return CertUtils.trustManager(null, TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
        }
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        return Collections.emptyList();
    }

    @Override
    public String toString() {
        return "JDK trusted certs";
    }

    @Override
    public boolean equals(Object o) {
        return o == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    static TrustConfig merge(TrustConfig trustConfig) {
        if (trustConfig == null) {
            return INSTANCE;
        }
        return new TrustConfig.CombiningTrustConfig(Arrays.asList(INSTANCE, trustConfig));
    }
}

