/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.netty4;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.netty4.IpFilterRemoteAddressFilter;
import org.elasticsearch.xpack.ssl.SSLConfiguration;
import org.elasticsearch.xpack.ssl.SSLService;

public class SecurityNetty4Transport
extends Netty4Transport {
    private final SSLService sslService;
    @Nullable
    private final IPFilter authenticator;
    private final SSLConfiguration sslConfiguration;
    private final Map<String, SSLConfiguration> profileConfiguration;
    private final boolean sslEnabled;

    public SecurityNetty4Transport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter authenticator, SSLService sslService) {
        super(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService);
        this.authenticator = authenticator;
        this.sslService = sslService;
        this.sslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        Settings transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
        if (this.sslEnabled) {
            this.sslConfiguration = sslService.sslConfiguration(transportSSLSettings, Settings.EMPTY);
            Map profileSettingsMap = settings.getGroups("transport.profiles.", true);
            HashMap profileConfiguration = new HashMap(profileSettingsMap.size() + 1);
            for (Map.Entry entry : profileSettingsMap.entrySet()) {
                Settings profileSettings = (Settings)entry.getValue();
                Settings profileSslSettings = SecurityNetty4Transport.profileSslSettings(profileSettings);
                SSLConfiguration configuration = sslService.sslConfiguration(profileSslSettings, transportSSLSettings);
                profileConfiguration.put(entry.getKey(), configuration);
            }
            if (!profileConfiguration.containsKey("default")) {
                profileConfiguration.put("default", this.sslConfiguration);
            }
            this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
        } else {
            this.profileConfiguration = Collections.emptyMap();
            this.sslConfiguration = null;
        }
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    protected ChannelHandler getServerChannelInitializer(String name) {
        if (this.sslEnabled) {
            SSLConfiguration configuration = this.profileConfiguration.get(name);
            if (configuration == null) {
                throw new IllegalStateException("unknown profile: " + name);
            }
            return new SecurityServerChannelInitializer(name, configuration);
        }
        return new IPFilterServerChannelInitializer(name);
    }

    protected ChannelHandler getClientChannelInitializer() {
        return new SecurityClientChannelInitializer();
    }

    protected void onException(TcpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            TcpChannel.closeChannel((TcpChannel)channel, (boolean)false);
        } else if (SSLExceptionHelper.isNotSslRecordException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            }
            TcpChannel.closeChannel((TcpChannel)channel, (boolean)false);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("connection {} closed during ssl handshake", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("connection {} closed during handshake", (Object)channel);
            }
            TcpChannel.closeChannel((TcpChannel)channel, (boolean)false);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException(e)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Message)new ParameterizedMessage("client did not trust server's certificate, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                this.logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            }
            TcpChannel.closeChannel((TcpChannel)channel, (boolean)false);
        } else {
            super.onException(channel, e);
        }
    }

    public static Settings profileSslSettings(Settings profileSettings) {
        return profileSettings.getByPrefix(Security.setting("ssl."));
    }

    private static class ClientSslHandlerInitializer
    extends ChannelOutboundHandlerAdapter {
        private final boolean hostnameVerificationEnabled;
        private final SSLConfiguration sslConfiguration;
        private final SSLService sslService;

        private ClientSslHandlerInitializer(SSLConfiguration sslConfiguration, SSLService sslService, boolean hostnameVerificationEnabled) {
            this.sslConfiguration = sslConfiguration;
            this.hostnameVerificationEnabled = hostnameVerificationEnabled;
            this.sslService = sslService;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            SSLEngine sslEngine;
            if (this.hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)remoteAddress;
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = this.sslService.createSSLEngine(this.sslConfiguration, null, -1);
            }
            sslEngine.setUseClientMode(true);
            ctx.pipeline().replace((ChannelHandler)this, "ssl", (ChannelHandler)new SslHandler(sslEngine));
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
    }

    private class SecurityClientChannelInitializer
    extends Netty4Transport.ClientChannelInitializer {
        private final boolean hostnameVerificationEnabled;

        SecurityClientChannelInitializer() {
            super((Netty4Transport)SecurityNetty4Transport.this);
            this.hostnameVerificationEnabled = SecurityNetty4Transport.this.sslEnabled && SecurityNetty4Transport.this.sslConfiguration.verificationMode().isHostnameVerificationEnabled();
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4Transport.this.sslEnabled) {
                ch.pipeline().addFirst(new ChannelHandler[]{new ClientSslHandlerInitializer(SecurityNetty4Transport.this.sslConfiguration, SecurityNetty4Transport.this.sslService, this.hostnameVerificationEnabled)});
            }
        }
    }

    class SecurityServerChannelInitializer
    extends IPFilterServerChannelInitializer {
        private final SSLConfiguration configuration;

        SecurityServerChannelInitializer(String name, SSLConfiguration configuration) {
            super(name);
            this.configuration = configuration;
        }

        @Override
        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            SSLEngine serverEngine = SecurityNetty4Transport.this.sslService.createSSLEngine(this.configuration, null, -1);
            serverEngine.setUseClientMode(false);
            IpFilterRemoteAddressFilter remoteAddressFilter = (IpFilterRemoteAddressFilter)ch.pipeline().get(IpFilterRemoteAddressFilter.class);
            SslHandler sslHandler = new SslHandler(serverEngine);
            if (remoteAddressFilter == null) {
                ch.pipeline().addFirst("sslhandler", (ChannelHandler)sslHandler);
            } else {
                ch.pipeline().addAfter("ipfilter", "sslhandler", (ChannelHandler)sslHandler);
            }
        }
    }

    class IPFilterServerChannelInitializer
    extends Netty4Transport.ServerChannelInitializer {
        IPFilterServerChannelInitializer(String name) {
            super((Netty4Transport)SecurityNetty4Transport.this, name);
        }

        protected void initChannel(Channel ch) throws Exception {
            super.initChannel(ch);
            if (SecurityNetty4Transport.this.authenticator != null) {
                ch.pipeline().addFirst("ipfilter", (ChannelHandler)new IpFilterRemoteAddressFilter(SecurityNetty4Transport.this.authenticator, this.name));
            }
        }
    }
}

