/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.template.TemplateUtils;

public class IndexLifecycleManager
extends AbstractComponent {
    public static final String INTERNAL_SECURITY_INDEX = ".security-6";
    public static final int INTERNAL_INDEX_FORMAT = 6;
    public static final String SECURITY_VERSION_STRING = "security-version";
    public static final String TEMPLATE_VERSION_PATTERN = Pattern.quote("${security.template.version}");
    private final String indexName;
    private final String templateName;
    private final Client client;
    private final List<BiConsumer<ClusterIndexHealth, ClusterIndexHealth>> indexHealthChangeListeners = new CopyOnWriteArrayList<BiConsumer<ClusterIndexHealth, ClusterIndexHealth>>();
    private final List<BiConsumer<Boolean, Boolean>> indexOutOfDateListeners = new CopyOnWriteArrayList<BiConsumer<Boolean, Boolean>>();
    private volatile State indexState = new State(false, false, false, false, null);

    public IndexLifecycleManager(Settings settings, Client client, String indexName, String templateName) {
        super(settings);
        this.client = client;
        this.indexName = indexName;
        this.templateName = templateName;
    }

    public boolean checkMappingVersion(Predicate<Version> requiredVersion) {
        State currentIndexState = this.indexState;
        return currentIndexState.mappingVersion == null || requiredVersion.test(currentIndexState.mappingVersion);
    }

    public boolean indexExists() {
        return this.indexState.indexExists;
    }

    public boolean isIndexUpToDate() {
        return this.indexState.isIndexUpToDate;
    }

    public boolean isAvailable() {
        return this.indexState.indexAvailable;
    }

    public boolean isWritable() {
        return this.indexState.canWriteToIndex;
    }

    public void addIndexHealthChangeListener(BiConsumer<ClusterIndexHealth, ClusterIndexHealth> listener) {
        this.indexHealthChangeListeners.add(listener);
    }

    public void addIndexOutOfDateListener(BiConsumer<Boolean, Boolean> listener) {
        this.indexOutOfDateListeners.add(listener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        boolean previousUpToDate = this.indexState.isIndexUpToDate;
        this.processClusterState(event.state());
        this.checkIndexHealthChange(event);
        if (previousUpToDate != this.indexState.isIndexUpToDate) {
            this.notifyIndexOutOfDateListeners(previousUpToDate, this.indexState.isIndexUpToDate);
        }
    }

    private void processClusterState(ClusterState clusterState) {
        assert (clusterState != null);
        IndexMetaData securityIndex = IndexLifecycleManager.resolveConcreteIndex(this.indexName, clusterState.metaData());
        boolean indexExists = securityIndex != null;
        boolean isIndexUpToDate = !indexExists || (Integer)IndexMetaData.INDEX_FORMAT_SETTING.get(securityIndex.getSettings()) == 6;
        boolean indexAvailable = this.checkIndexAvailable(clusterState);
        boolean templateIsUpToDate = TemplateUtils.checkTemplateExistsAndIsUpToDate(this.templateName, SECURITY_VERSION_STRING, clusterState, this.logger);
        boolean mappingIsUpToDate = this.checkIndexMappingUpToDate(clusterState);
        boolean canWriteToIndex = templateIsUpToDate && (mappingIsUpToDate || isIndexUpToDate);
        Version mappingVersion = this.oldestIndexMappingVersion(clusterState);
        this.indexState = new State(indexExists, isIndexUpToDate, indexAvailable, canWriteToIndex, mappingVersion);
    }

    private void checkIndexHealthChange(ClusterChangedEvent event) {
        ClusterState state = event.state();
        ClusterState previousState = event.previousState();
        IndexMetaData indexMetaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, state.metaData());
        IndexMetaData previousIndexMetaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, previousState.metaData());
        if (indexMetaData != null) {
            ClusterIndexHealth previousHealth;
            ClusterIndexHealth currentHealth = new ClusterIndexHealth(indexMetaData, state.getRoutingTable().index(indexMetaData.getIndex()));
            ClusterIndexHealth clusterIndexHealth = previousHealth = previousIndexMetaData != null ? new ClusterIndexHealth(previousIndexMetaData, previousState.getRoutingTable().index(previousIndexMetaData.getIndex())) : null;
            if (previousHealth == null || previousHealth.getStatus() != currentHealth.getStatus()) {
                this.notifyIndexHealthChangeListeners(previousHealth, currentHealth);
            }
        } else if (previousIndexMetaData != null) {
            ClusterIndexHealth previousHealth = new ClusterIndexHealth(previousIndexMetaData, previousState.getRoutingTable().index(previousIndexMetaData.getIndex()));
            this.notifyIndexHealthChangeListeners(previousHealth, null);
        }
    }

    private void notifyIndexHealthChangeListeners(ClusterIndexHealth previousHealth, ClusterIndexHealth currentHealth) {
        for (BiConsumer<ClusterIndexHealth, ClusterIndexHealth> consumer : this.indexHealthChangeListeners) {
            try {
                consumer.accept(previousHealth, currentHealth);
            }
            catch (Exception e) {
                this.logger.warn((Message)new ParameterizedMessage("failed to notify listener [{}] of index health change", consumer), (Throwable)e);
            }
        }
    }

    private void notifyIndexOutOfDateListeners(boolean previous, boolean current) {
        for (BiConsumer<Boolean, Boolean> consumer : this.indexOutOfDateListeners) {
            try {
                consumer.accept(previous, current);
            }
            catch (Exception e) {
                this.logger.warn((Message)new ParameterizedMessage("failed to notify listener [{}] of index out of date change", consumer), (Throwable)e);
            }
        }
    }

    private boolean checkIndexAvailable(ClusterState state) {
        IndexRoutingTable routingTable = this.getIndexRoutingTable(state);
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            return true;
        }
        this.logger.debug("Security index [{}] is not yet active", (Object)this.indexName);
        return false;
    }

    private IndexRoutingTable getIndexRoutingTable(ClusterState clusterState) {
        IndexMetaData metaData = IndexLifecycleManager.resolveConcreteIndex(this.indexName, clusterState.metaData());
        if (metaData == null) {
            return null;
        }
        return clusterState.routingTable().index(metaData.getIndex());
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, ClusterState state, Logger logger, Predicate<Version> predicate) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches(templateName, SECURITY_VERSION_STRING, state, logger, predicate);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        return this.checkIndexMappingVersionMatches(clusterState, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private boolean checkIndexMappingVersionMatches(ClusterState clusterState, Predicate<Version> predicate) {
        return IndexLifecycleManager.checkIndexMappingVersionMatches(this.indexName, clusterState, this.logger, predicate);
    }

    public static boolean checkIndexMappingVersionMatches(String indexName, ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        return IndexLifecycleManager.loadIndexMappingVersions(indexName, clusterState, logger).stream().allMatch(predicate);
    }

    private Version oldestIndexMappingVersion(ClusterState clusterState) {
        Set<Version> versions = IndexLifecycleManager.loadIndexMappingVersions(this.indexName, clusterState, this.logger);
        return versions.stream().min(Version::compareTo).orElse(null);
    }

    private static Set<Version> loadIndexMappingVersions(String indexName, ClusterState clusterState, Logger logger) {
        HashSet<Version> versions = new HashSet<Version>();
        IndexMetaData indexMetaData = IndexLifecycleManager.resolveConcreteIndex(indexName, clusterState.metaData());
        if (indexMetaData != null) {
            for (Object object : indexMetaData.getMappings().values().toArray()) {
                MappingMetaData mappingMetaData = (MappingMetaData)object;
                if (mappingMetaData.type().equals("_default_")) continue;
                versions.add(IndexLifecycleManager.readMappingVersion(indexName, mappingMetaData, logger));
            }
        }
        return versions;
    }

    private static IndexMetaData resolveConcreteIndex(String indexOrAliasName, MetaData metaData) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(indexOrAliasName);
        if (aliasOrIndex != null) {
            List indices = aliasOrIndex.getIndices();
            if (aliasOrIndex.isAlias() && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices.stream().map(imd -> imd.getIndex().getName()).collect(Collectors.toList()));
            }
            return (IndexMetaData)indices.get(0);
        }
        return null;
    }

    private static Version readMappingVersion(String indexName, MappingMetaData mappingMetaData, Logger logger) {
        try {
            Map meta = (Map)mappingMetaData.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetaData.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read security-version string in index " + indexName);
            }
            return Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING)));
        }
        catch (ElasticsearchParseException e) {
            logger.error((Message)new ParameterizedMessage("Cannot parse the mapping for index [{}]", (Object)indexName), (Throwable)e);
            throw new ElasticsearchException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    public <T> void createIndexIfNeededThenExecute(final ActionListener<T> listener, final Runnable andThen) {
        if (this.indexState.indexExists) {
            andThen.run();
        } else {
            CreateIndexRequest request = new CreateIndexRequest(INTERNAL_SECURITY_INDEX);
            request.alias(new Alias(".security"));
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", request, new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse createIndexResponse) {
                    if (createIndexResponse.isAcknowledged()) {
                        andThen.run();
                    } else {
                        listener.onFailure((Exception)new ElasticsearchException("Failed to create security index", new Object[0]));
                    }
                }

                public void onFailure(Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof ResourceAlreadyExistsException) {
                        andThen.run();
                    } else {
                        listener.onFailure(e);
                    }
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
        }
    }

    private static class State {
        private final boolean indexExists;
        private final boolean isIndexUpToDate;
        private final boolean indexAvailable;
        private final boolean canWriteToIndex;
        private final Version mappingVersion;

        private State(boolean indexExists, boolean isIndexUpToDate, boolean indexAvailable, boolean canWriteToIndex, Version mappingVersion) {
            this.indexExists = indexExists;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailable = indexAvailable;
            this.canWriteToIndex = canWriteToIndex;
            this.mappingVersion = mappingVersion;
        }
    }
}

