/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.security.action.user.DeleteUserRequestBuilder;
import org.elasticsearch.xpack.security.action.user.DeleteUserResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestDeleteUserAction
extends SecurityBaseRestHandler {
    public RestDeleteUserAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.DELETE, "/_xpack/security/user/{username}", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.DELETE, "/_shield/user/{username}", (RestHandler)this, "[DELETE /_shield/user/{username}] is deprecated! Use [DELETE /_xpack/security/user/{username}] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_security_delete_user_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String username = request.param("username");
        String refresh = request.param("refresh");
        return channel -> ((DeleteUserRequestBuilder)new SecurityClient((ElasticsearchClient)client).prepareDeleteUser(username).setRefreshPolicy(refresh)).execute((ActionListener)new RestBuilderListener<DeleteUserResponse>(channel){

            public RestResponse buildResponse(DeleteUserResponse response, XContentBuilder builder) throws Exception {
                return new BytesRestResponse(response.found() ? RestStatus.OK : RestStatus.NOT_FOUND, builder.startObject().field("found", response.found()).endObject());
            }
        });
    }
}

