/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.role;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestClearRolesCacheAction
extends SecurityBaseRestHandler {
    public RestClearRolesCacheAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/role/{name}/_clear_cache", (RestHandler)this);
        controller.registerAsDeprecatedHandler(RestRequest.Method.POST, "/_shield/role/{name}/_clear_cache", (RestHandler)this, "[POST /_shield/role/{name}/_clear_cache] is deprecated! Use [POST /_xpack/security/role/{name}/_clear_cache] instead.", this.deprecationLogger);
    }

    public String getName() {
        return "xpack_security_clear_roles_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] roles = request.paramAsStringArrayOrEmptyIfAll("name");
        ClearRolesCacheRequest req = new ClearRolesCacheRequest().names(roles);
        return channel -> new SecurityClient((ElasticsearchClient)client).clearRolesCache(req, (ActionListener<ClearRolesCacheResponse>)new RestActions.NodesResponseRestListener(channel));
    }
}

