/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public abstract class SecurityBaseRestHandler
extends BaseRestHandler {
    protected final XPackLicenseState licenseState;

    protected SecurityBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings);
        this.licenseState = licenseState;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BaseRestHandler.RestChannelConsumer consumer = this.innerPrepareRequest(request, client);
        if (this.licenseState.isAuthAllowed()) {
            return consumer;
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(channel, (Exception)LicenseUtils.newComplianceException("security")));
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;
}

