/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.accesscontrol;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authz.accesscontrol.DocumentSubsetReader;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.User;

public class SecurityIndexSearcherWrapper
extends org.elasticsearch.index.shard.IndexSearcherWrapper {
    private final Function<ShardId, QueryShardContext> queryShardContextProvider;
    private final BitsetFilterCache bitsetFilterCache;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final Logger logger;
    private final ScriptService scriptService;

    public SecurityIndexSearcherWrapper(IndexSettings indexSettings, Function<ShardId, QueryShardContext> queryShardContextProvider, BitsetFilterCache bitsetFilterCache, ThreadContext threadContext, XPackLicenseState licenseState, ScriptService scriptService) {
        this.scriptService = scriptService;
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)indexSettings.getSettings(), (String[])new String[0]);
        this.queryShardContextProvider = queryShardContextProvider;
        this.bitsetFilterCache = bitsetFilterCache;
        this.threadContext = threadContext;
        this.licenseState = licenseState;
    }

    protected DirectoryReader wrap(DirectoryReader reader) {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return reader;
        }
        try {
            IndicesAccessControl indicesAccessControl = this.getIndicesAccessControl();
            ShardId shardId = ShardUtils.extractShardId((DirectoryReader)reader);
            if (shardId == null) {
                throw new IllegalStateException(LoggerMessageFormat.format((String)"couldn't extract shardId from reader [{}]", (Object[])new Object[]{reader}));
            }
            IndicesAccessControl.IndexAccessControl permissions = indicesAccessControl.getIndexPermissions(shardId.getIndexName());
            if (permissions == null) {
                return reader;
            }
            if (permissions.getQueries() != null) {
                BooleanQuery.Builder filter = new BooleanQuery.Builder();
                for (BytesReference bytesReference : permissions.getQueries()) {
                    QueryShardContext queryShardContext = this.queryShardContextProvider.apply(shardId);
                    String templateResult = this.evaluateTemplate(bytesReference.utf8ToString());
                    XContentParser parser = XContentFactory.xContent((CharSequence)templateResult).createParser(queryShardContext.getXContentRegistry(), templateResult);
                    Throwable throwable = null;
                    try {
                        QueryBuilder queryBuilder = queryShardContext.parseInnerQueryBuilder(parser);
                        SecurityIndexSearcherWrapper.verifyRoleQuery(queryBuilder);
                        SecurityIndexSearcherWrapper.failIfQueryUsesClient(queryBuilder, (QueryRewriteContext)queryShardContext);
                        Query roleQuery = queryShardContext.toFilter(queryBuilder).query();
                        filter.add(roleQuery, BooleanClause.Occur.SHOULD);
                        if (!queryShardContext.getMapperService().hasNested()) continue;
                        BitSetProducer rootDocs = queryShardContext.bitsetFilter(Queries.newNonNestedFilter((Version)queryShardContext.indexVersionCreated()));
                        ToChildBlockJoinQuery includeNestedDocs = new ToChildBlockJoinQuery(roleQuery, rootDocs);
                        filter.add((Query)includeNestedDocs, BooleanClause.Occur.SHOULD);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (parser == null) continue;
                        if (throwable != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        parser.close();
                    }
                }
                filter.setMinimumNumberShouldMatch(1);
                reader = DocumentSubsetReader.wrap(reader, this.bitsetFilterCache, (Query)new ConstantScoreQuery((Query)filter.build()));
            }
            return permissions.getFieldPermissions().filter((DirectoryReader)reader);
        }
        catch (IOException e) {
            this.logger.error("Unable to apply field level security");
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
    }

    protected IndexSearcher wrap(IndexSearcher searcher) throws EngineException {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return searcher;
        }
        DirectoryReader directoryReader = (DirectoryReader)searcher.getIndexReader();
        if (directoryReader instanceof DocumentSubsetReader.DocumentSubsetDirectoryReader) {
            IndexSearcherWrapper indexSearcher = new IndexSearcherWrapper((DocumentSubsetReader.DocumentSubsetDirectoryReader)directoryReader);
            indexSearcher.setQueryCache(indexSearcher.getQueryCache());
            indexSearcher.setQueryCachingPolicy(indexSearcher.getQueryCachingPolicy());
            indexSearcher.setSimilarity(indexSearcher.getSimilarity(true));
            return indexSearcher;
        }
        return searcher;
    }

    static void intersectScorerAndRoleBits(Scorer scorer, SparseFixedBitSet roleBits, LeafCollector collector, Bits acceptDocs) throws IOException {
        DocIdSetIterator iterator = ConjunctionDISI.intersectIterators(Arrays.asList(new BitSetIterator((BitSet)roleBits, (long)roleBits.approximateCardinality()), scorer.iterator()));
        int docId = iterator.nextDoc();
        while (docId < Integer.MAX_VALUE) {
            if (acceptDocs == null || acceptDocs.get(docId)) {
                collector.collect(docId);
            }
            docId = iterator.nextDoc();
        }
    }

    String evaluateTemplate(String querySource) throws IOException {
        try (XContentParser parser = XContentFactory.xContent((CharSequence)querySource).createParser(NamedXContentRegistry.EMPTY, querySource);){
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
            }
            token = parser.nextToken();
            if (token != XContentParser.Token.FIELD_NAME) {
                throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
            }
            if ("template".equals(parser.currentName())) {
                token = parser.nextToken();
                if (token != XContentParser.Token.START_OBJECT) {
                    throw new ElasticsearchParseException("Unexpected token [" + token + "]", new Object[0]);
                }
                Script script = Script.parse((XContentParser)parser);
                HashMap params = new HashMap();
                if (script.getParams() != null) {
                    params.putAll(script.getParams());
                }
                User user = this.getUser();
                HashMap<String, Object> userModel = new HashMap<String, Object>();
                userModel.put("username", user.principal());
                userModel.put("full_name", user.fullName());
                userModel.put("email", user.email());
                userModel.put("roles", Arrays.asList(user.roles()));
                userModel.put("metadata", Collections.unmodifiableMap(user.metadata()));
                params.put("_user", userModel);
                script = new Script(script.getType(), script.getType() == ScriptType.STORED ? null : "mustache", script.getIdOrCode(), script.getOptions(), params);
                TemplateScript compiledTemplate = ((TemplateScript.Factory)this.scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(script.getParams());
                String string = compiledTemplate.execute();
                return string;
            }
            String string = querySource;
            return string;
        }
    }

    protected IndicesAccessControl getIndicesAccessControl() {
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
        if (indicesAccessControl == null) {
            throw Exceptions.authorizationError("no indices permissions found", new Object[0]);
        }
        return indicesAccessControl;
    }

    protected User getUser() {
        Authentication authentication = Authentication.getAuthentication(this.threadContext);
        return authentication.getUser();
    }

    static void verifyRoleQuery(QueryBuilder queryBuilder) throws IOException {
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder termsQueryBuilder = (TermsQueryBuilder)queryBuilder;
            if (termsQueryBuilder.termsLookup() != null) {
                throw new IllegalArgumentException("terms query with terms lookup isn't supported as part of a role query");
            }
        } else if (queryBuilder instanceof GeoShapeQueryBuilder) {
            GeoShapeQueryBuilder geoShapeQueryBuilder = (GeoShapeQueryBuilder)queryBuilder;
            if (geoShapeQueryBuilder.shape() == null) {
                throw new IllegalArgumentException("geoshape query referring to indexed shapes isn't support as part of a role query");
            }
        } else {
            if (queryBuilder.getName().equals("percolate")) {
                throw new IllegalArgumentException("percolate query isn't support as part of a role query");
            }
            if (queryBuilder.getName().equals("has_child")) {
                throw new IllegalArgumentException("has_child query isn't support as part of a role query");
            }
            if (queryBuilder.getName().equals("has_parent")) {
                throw new IllegalArgumentException("has_parent query isn't support as part of a role query");
            }
            if (queryBuilder instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)queryBuilder;
                ArrayList clauses = new ArrayList();
                clauses.addAll(boolQueryBuilder.filter());
                clauses.addAll(boolQueryBuilder.must());
                clauses.addAll(boolQueryBuilder.mustNot());
                clauses.addAll(boolQueryBuilder.should());
                for (QueryBuilder clause : clauses) {
                    SecurityIndexSearcherWrapper.verifyRoleQuery(clause);
                }
            } else if (queryBuilder instanceof ConstantScoreQueryBuilder) {
                SecurityIndexSearcherWrapper.verifyRoleQuery(((ConstantScoreQueryBuilder)queryBuilder).innerQuery());
            } else if (queryBuilder instanceof FunctionScoreQueryBuilder) {
                SecurityIndexSearcherWrapper.verifyRoleQuery(((FunctionScoreQueryBuilder)queryBuilder).query());
            } else if (queryBuilder instanceof BoostingQueryBuilder) {
                SecurityIndexSearcherWrapper.verifyRoleQuery(((BoostingQueryBuilder)queryBuilder).negativeQuery());
                SecurityIndexSearcherWrapper.verifyRoleQuery(((BoostingQueryBuilder)queryBuilder).positiveQuery());
            }
        }
    }

    static void failIfQueryUsesClient(QueryBuilder queryBuilder, QueryRewriteContext original) throws IOException {
        QueryRewriteContext copy = new QueryRewriteContext(original.getXContentRegistry(), original.getWriteableRegistry(), null, () -> ((QueryRewriteContext)original).nowInMillis());
        Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)copy);
        if (copy.hasAsyncActions()) {
            throw new IllegalStateException("role queries are not allowed to execute additional requests");
        }
    }

    static class IndexSearcherWrapper
    extends IndexSearcher {
        IndexSearcherWrapper(DocumentSubsetReader.DocumentSubsetDirectoryReader r) {
            super((IndexReader)r);
        }

        protected void search(List<LeafReaderContext> leaves, Weight weight, Collector collector) throws IOException {
            for (LeafReaderContext ctx : leaves) {
                LeafCollector leafCollector;
                try {
                    leafCollector = collector.getLeafCollector(ctx);
                }
                catch (CollectionTerminatedException e) {
                    continue;
                }
                DocumentSubsetReader reader = (DocumentSubsetReader)ctx.reader();
                BitSet roleQueryBits = reader.getRoleQueryBits();
                if (roleQueryBits == null) continue;
                if (roleQueryBits instanceof SparseFixedBitSet) {
                    Scorer scorer = weight.scorer(ctx);
                    if (scorer == null) continue;
                    SparseFixedBitSet sparseFixedBitSet = (SparseFixedBitSet)roleQueryBits;
                    Bits realLiveDocs = reader.getWrappedLiveDocs();
                    try {
                        SecurityIndexSearcherWrapper.intersectScorerAndRoleBits(scorer, sparseFixedBitSet, leafCollector, realLiveDocs);
                    }
                    catch (CollectionTerminatedException collectionTerminatedException) {}
                    continue;
                }
                BulkScorer bulkScorer = weight.bulkScorer(ctx);
                if (bulkScorer == null) continue;
                Bits liveDocs = reader.getLiveDocs();
                try {
                    bulkScorer.score(leafCollector, liveDocs);
                }
                catch (CollectionTerminatedException collectionTerminatedException) {}
            }
        }
    }
}

