/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import org.elasticsearch.action.AliasesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.graph.action.GraphExploreRequest;
import org.elasticsearch.xpack.security.authz.AuthorizedIndices;

public class IndicesAndAliasesResolver {
    public static final String NO_INDEX_PLACEHOLDER = "-*";
    private static final ResolvedIndices NO_INDEX_PLACEHOLDER_RESOLVED = ResolvedIndices.access$000(new String[]{"-*"});
    private static final String[] NO_INDICES_ARRAY = new String[]{"*", "-*"};
    static final List<String> NO_INDICES_LIST = Arrays.asList(NO_INDICES_ARRAY);
    private final IndexNameExpressionResolver nameExpressionResolver;
    private final RemoteClusterResolver remoteClusterResolver;

    public IndicesAndAliasesResolver(Settings settings, ClusterService clusterService) {
        this.nameExpressionResolver = new IndexNameExpressionResolver(settings);
        this.remoteClusterResolver = new RemoteClusterResolver(settings, clusterService.getClusterSettings());
    }

    public ResolvedIndices resolve(TransportRequest request, MetaData metaData, AuthorizedIndices authorizedIndices) {
        if (request instanceof IndicesAliasesRequest) {
            ResolvedIndices indices = ResolvedIndices.empty();
            IndicesAliasesRequest indicesAliasesRequest = (IndicesAliasesRequest)request;
            for (IndicesRequest indicesRequest : indicesAliasesRequest.getAliasActions()) {
                indices = ResolvedIndices.add(indices, this.resolveIndicesAndAliases(indicesRequest, metaData, authorizedIndices));
            }
            return indices;
        }
        if (!(request instanceof IndicesRequest)) {
            throw new IllegalStateException("Request [" + request + "] is not an Indices request, but should be.");
        }
        return this.resolveIndicesAndAliases((IndicesRequest)request, metaData, authorizedIndices);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ResolvedIndices resolveIndicesAndAliases(IndicesRequest indicesRequest, MetaData metaData, AuthorizedIndices authorizedIndices) {
        ResolvedIndices indices;
        boolean indicesReplacedWithNoIndices = false;
        if (indicesRequest instanceof PutMappingRequest && ((PutMappingRequest)indicesRequest).getConcreteIndex() != null) {
            assert (indicesRequest.indices() == null || indicesRequest.indices().length == 0) : "indices are: " + Arrays.toString(indicesRequest.indices());
            return ResolvedIndices.local(new String[]{((PutMappingRequest)indicesRequest).getConcreteIndex().getName()});
        }
        if (indicesRequest instanceof IndicesRequest.Replaceable) {
            IndicesRequest.Replaceable replaceable = (IndicesRequest.Replaceable)indicesRequest;
            boolean replaceWildcards = indicesRequest.indicesOptions().expandWildcardsOpen() || indicesRequest.indicesOptions().expandWildcardsClosed();
            IndicesOptions indicesOptions = indicesRequest.indicesOptions();
            if (indicesRequest instanceof IndicesExistsRequest) {
                indicesOptions = IndicesOptions.fromOptions((boolean)true, (boolean)true, (boolean)indicesOptions.expandWildcardsOpen(), (boolean)indicesOptions.expandWildcardsClosed());
            }
            ResolvedIndices result = ResolvedIndices.empty();
            if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
                if (replaceWildcards) {
                    for (String string : authorizedIndices.get()) {
                        if (!IndicesAndAliasesResolver.isIndexVisible(string, indicesOptions, metaData)) continue;
                        result = ResolvedIndices.add(result, ResolvedIndices.local(new String[]{string}));
                    }
                }
            } else {
                void var11_19;
                ResolvedIndices split = IndicesAndAliasesResolver.allowsRemoteIndices(indicesRequest) ? this.remoteClusterResolver.splitLocalAndRemoteIndexNames(indicesRequest.indices()) : ResolvedIndices.local(indicesRequest.indices());
                List<String> list = this.replaceWildcardsWithAuthorizedIndices(split.getLocal(), indicesOptions, metaData, authorizedIndices.get(), replaceWildcards);
                if (indicesOptions.ignoreUnavailable()) {
                    List list2 = list.stream().filter(authorizedIndices.get()::contains).collect(Collectors.toList());
                }
                result = new ResolvedIndices(new ArrayList<String>((Collection<String>)var11_19), split.getRemote());
            }
            if (result.isEmpty()) {
                if (!indicesOptions.allowNoIndices()) throw new IndexNotFoundException(Arrays.toString(indicesRequest.indices()));
                replaceable.indices(NO_INDICES_ARRAY);
                indicesReplacedWithNoIndices = true;
                indices = NO_INDEX_PLACEHOLDER_RESOLVED;
            } else {
                replaceable.indices(result.toArray());
                indices = result;
            }
        } else {
            if (this.containsWildcards(indicesRequest)) {
                throw new IllegalStateException("There are no external requests known to support wildcards that don't support replacing their indices");
            }
            ArrayList<String> resolvedNames = new ArrayList<String>();
            for (String name : indicesRequest.indices()) {
                resolvedNames.add(this.nameExpressionResolver.resolveDateMathExpression(name));
            }
            indices = new ResolvedIndices(resolvedNames, new ArrayList<String>());
        }
        if (!(indicesRequest instanceof AliasesRequest)) return indices;
        AliasesRequest aliasesRequest = (AliasesRequest)indicesRequest;
        if (aliasesRequest.expandAliasesWildcards()) {
            List<String> aliases = this.replaceWildcardsWithAuthorizedAliases(aliasesRequest.aliases(), this.loadAuthorizedAliases(authorizedIndices.get(), metaData));
            aliasesRequest.aliases(aliases.toArray(new String[aliases.size()]));
        }
        if (!indicesReplacedWithNoIndices) return ResolvedIndices.add(indices, ResolvedIndices.local(aliasesRequest.aliases()));
        if (indicesRequest instanceof GetAliasesRequest) return indices;
        throw new IllegalStateException(GetAliasesRequest.class.getSimpleName() + " is the only known request implementing " + AliasesRequest.class.getSimpleName() + " that may allow no indices. Found [" + indicesRequest.getClass().getName() + "] which ended up with an empty set of indices.");
    }

    public static boolean allowsRemoteIndices(IndicesRequest request) {
        return request instanceof SearchRequest || request instanceof FieldCapabilitiesRequest || request instanceof GraphExploreRequest;
    }

    private List<String> loadAuthorizedAliases(List<String> authorizedIndices, MetaData metaData) {
        ArrayList<String> authorizedAliases = new ArrayList<String>();
        SortedMap existingAliases = metaData.getAliasAndIndexLookup();
        for (String authorizedIndex : authorizedIndices) {
            AliasOrIndex aliasOrIndex = (AliasOrIndex)existingAliases.get(authorizedIndex);
            if (aliasOrIndex == null || !aliasOrIndex.isAlias()) continue;
            authorizedAliases.add(authorizedIndex);
        }
        return authorizedAliases;
    }

    private List<String> replaceWildcardsWithAuthorizedAliases(String[] aliases, List<String> authorizedAliases) {
        boolean matchAllAliases;
        ArrayList<String> finalAliases = new ArrayList<String>();
        boolean bl = matchAllAliases = aliases.length == 0;
        if (matchAllAliases) {
            finalAliases.addAll(authorizedAliases);
        }
        for (String aliasPattern : aliases) {
            if (aliasPattern.equals("_all")) {
                matchAllAliases = true;
                finalAliases.addAll(authorizedAliases);
                continue;
            }
            if (Regex.isSimpleMatchPattern((String)aliasPattern)) {
                for (String authorizedAlias : authorizedAliases) {
                    if (!Regex.simpleMatch((String)aliasPattern, (String)authorizedAlias)) continue;
                    finalAliases.add(authorizedAlias);
                }
                continue;
            }
            finalAliases.add(aliasPattern);
        }
        if (finalAliases.isEmpty()) {
            String indexName = matchAllAliases ? "_all" : Arrays.toString(aliases);
            throw new IndexNotFoundException(indexName);
        }
        return finalAliases;
    }

    private boolean containsWildcards(IndicesRequest indicesRequest) {
        if (IndexNameExpressionResolver.isAllIndices(IndicesAndAliasesResolver.indicesList(indicesRequest.indices()))) {
            return true;
        }
        for (String index : indicesRequest.indices()) {
            if (!Regex.isSimpleMatchPattern((String)index)) continue;
            return true;
        }
        return false;
    }

    private List<String> replaceWildcardsWithAuthorizedIndices(Iterable<String> indices, IndicesOptions indicesOptions, MetaData metaData, List<String> authorizedIndices, boolean replaceWildcards) {
        ArrayList<String> finalIndices = new ArrayList<String>();
        boolean wildcardSeen = false;
        for (String index : indices) {
            String aliasOrIndex;
            boolean minus = false;
            if (index.charAt(0) == '-' && wildcardSeen) {
                aliasOrIndex = index.substring(1);
                minus = true;
            } else {
                aliasOrIndex = index;
            }
            String dateMathName = this.nameExpressionResolver.resolveDateMathExpression(aliasOrIndex);
            if (dateMathName != aliasOrIndex) {
                assert (!dateMathName.equals(aliasOrIndex));
                if (replaceWildcards && Regex.isSimpleMatchPattern((String)dateMathName)) {
                    aliasOrIndex = dateMathName;
                } else if (authorizedIndices.contains(dateMathName) && IndicesAndAliasesResolver.isIndexVisible(dateMathName, indicesOptions, metaData, true)) {
                    if (minus) {
                        finalIndices.remove(dateMathName);
                    } else {
                        finalIndices.add(dateMathName);
                    }
                } else if (!indicesOptions.ignoreUnavailable()) {
                    throw new IndexNotFoundException(dateMathName);
                }
            }
            if (replaceWildcards && Regex.isSimpleMatchPattern((String)aliasOrIndex)) {
                wildcardSeen = true;
                HashSet<String> resolvedIndices = new HashSet<String>();
                for (String authorizedIndex : authorizedIndices) {
                    if (!Regex.simpleMatch((String)aliasOrIndex, (String)authorizedIndex) || !IndicesAndAliasesResolver.isIndexVisible(authorizedIndex, indicesOptions, metaData)) continue;
                    resolvedIndices.add(authorizedIndex);
                }
                if (resolvedIndices.isEmpty()) {
                    if (indicesOptions.allowNoIndices()) continue;
                    throw new IndexNotFoundException(aliasOrIndex);
                }
                if (minus) {
                    finalIndices.removeAll(resolvedIndices);
                    continue;
                }
                finalIndices.addAll(resolvedIndices);
                continue;
            }
            if (dateMathName != aliasOrIndex) continue;
            assert (dateMathName.equals(aliasOrIndex));
            if (minus) {
                finalIndices.remove(aliasOrIndex);
                continue;
            }
            finalIndices.add(aliasOrIndex);
        }
        return finalIndices;
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData) {
        return IndicesAndAliasesResolver.isIndexVisible(index, indicesOptions, metaData, false);
    }

    private static boolean isIndexVisible(String index, IndicesOptions indicesOptions, MetaData metaData, boolean dateMathExpression) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(index);
        if (aliasOrIndex.isAlias()) {
            return !indicesOptions.ignoreAliases();
        }
        assert (aliasOrIndex.getIndices().size() == 1) : "concrete index must point to a single index";
        IndexMetaData indexMetaData = (IndexMetaData)aliasOrIndex.getIndices().get(0);
        if (indexMetaData.getState() == IndexMetaData.State.CLOSE && (indicesOptions.expandWildcardsClosed() || dateMathExpression)) {
            return true;
        }
        return indexMetaData.getState() == IndexMetaData.State.OPEN && (indicesOptions.expandWildcardsOpen() || dateMathExpression);
    }

    private static List<String> indicesList(String[] list) {
        return list == null ? null : Arrays.asList(list);
    }

    public static class ResolvedIndices {
        private final List<String> local;
        private final List<String> remote;

        ResolvedIndices(List<String> local, List<String> remote) {
            this.local = local;
            this.remote = remote;
        }

        private static ResolvedIndices empty() {
            return new ResolvedIndices(Collections.emptyList(), Collections.emptyList());
        }

        private static ResolvedIndices local(String ... names) {
            return new ResolvedIndices(Arrays.asList(names), Collections.emptyList());
        }

        public List<String> getLocal() {
            return Collections.unmodifiableList(this.local);
        }

        public List<String> getRemote() {
            return Collections.unmodifiableList(this.remote);
        }

        public boolean isEmpty() {
            return this.local.isEmpty() && this.remote.isEmpty();
        }

        public boolean isNoIndicesPlaceholder() {
            return this.remote.isEmpty() && this.local.size() == 1 && this.local.contains(IndicesAndAliasesResolver.NO_INDEX_PLACEHOLDER);
        }

        private String[] toArray() {
            String[] array = new String[this.local.size() + this.remote.size()];
            int i = 0;
            for (String index : this.local) {
                array[i++] = index;
            }
            for (String index : this.remote) {
                array[i++] = index;
            }
            return array;
        }

        private static ResolvedIndices add(ResolvedIndices a, ResolvedIndices b) {
            ArrayList<String> local = new ArrayList<String>(a.local.size() + b.local.size());
            local.addAll(a.local);
            local.addAll(b.local);
            ArrayList<String> remote = new ArrayList<String>(a.remote.size() + b.remote.size());
            remote.addAll(a.remote);
            remote.addAll(b.remote);
            return new ResolvedIndices(local, remote);
        }
    }

    private static class RemoteClusterResolver
    extends RemoteClusterAware {
        private final CopyOnWriteArraySet<String> clusters;

        private RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
            super(settings);
            this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.buildRemoteClustersSeeds((Settings)settings).keySet());
            this.listenForUpdates(clusterSettings);
        }

        protected Set<String> getRemoteClusterNames() {
            return this.clusters;
        }

        protected void updateRemoteCluster(String clusterAlias, List<InetSocketAddress> addresses) {
            if (addresses.isEmpty()) {
                this.clusters.remove(clusterAlias);
            } else {
                this.clusters.add(clusterAlias);
            }
        }

        ResolvedIndices splitLocalAndRemoteIndexNames(String ... indices) {
            Map map = super.groupClusterIndices(indices, exists -> false);
            List local = (List)map.remove("");
            List<String> remote = map.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> (String)e.getKey() + ':' + v)).collect(Collectors.toList());
            return new ResolvedIndices(local == null ? Collections.emptyList() : local, remote);
        }
    }
}

