/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.nio.file.Path;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.DnRoleMapper;

public class RoleMappingFileBootstrapCheck
implements BootstrapCheck {
    private final RealmConfig realmConfig;
    private final Path path;

    RoleMappingFileBootstrapCheck(RealmConfig config, Path path) {
        this.realmConfig = config;
        this.path = path;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        try {
            DnRoleMapper.parseFile(this.path, this.realmConfig.logger(this.getClass()), this.realmConfig.type(), this.realmConfig.name(), true);
            return BootstrapCheck.BootstrapCheckResult.success();
        }
        catch (Exception e) {
            return BootstrapCheck.BootstrapCheckResult.failure((String)e.getMessage());
        }
    }

    public boolean alwaysEnforce() {
        return true;
    }

    public static BootstrapCheck create(RealmConfig realmConfig) {
        if (realmConfig.enabled() && DnRoleMapper.ROLE_MAPPING_FILE_SETTING.exists(realmConfig.settings())) {
            Path file = DnRoleMapper.resolveFile(realmConfig.settings(), realmConfig.env());
            return new RoleMappingFileBootstrapCheck(realmConfig, file);
        }
        return null;
    }
}

