/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.pki;

import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.security.authc.Realm;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.pki.X509AuthenticationToken;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.ssl.CertUtils;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;

public class PkiRealm
extends Realm {
    public static final String PKI_CERT_HEADER_NAME = "__SECURITY_CLIENT_CERTIFICATE";
    public static final String TYPE = "pki";
    static final String DEFAULT_USERNAME_PATTERN = "CN=(.*?)(?:,|$)";
    private static final Setting<Pattern> USERNAME_PATTERN_SETTING = new Setting("username_pattern", "CN=(.*?)(?:,|$)", s -> Pattern.compile(s, 2), new Setting.Property[]{Setting.Property.NodeScope});
    private static final SSLConfigurationSettings SSL_SETTINGS = SSLConfigurationSettings.withoutPrefix();
    private static final String AUTH_TYPE = "UNKNOWN";
    private final X509TrustManager trustManager;
    private final Pattern principalPattern;
    private final UserRoleMapper roleMapper;

    public PkiRealm(RealmConfig config, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore) {
        this(config, new CompositeRoleMapper(TYPE, config, watcherService, nativeRoleMappingStore));
    }

    PkiRealm(RealmConfig config, UserRoleMapper roleMapper) {
        super(TYPE, config);
        this.trustManager = PkiRealm.trustManagers(config);
        this.principalPattern = (Pattern)USERNAME_PATTERN_SETTING.get(config.settings());
        this.roleMapper = roleMapper;
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return token instanceof X509AuthenticationToken;
    }

    @Override
    public X509AuthenticationToken token(ThreadContext context) {
        return PkiRealm.token(context.getTransient(PKI_CERT_HEADER_NAME), this.principalPattern, this.logger);
    }

    @Override
    public void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult> listener) {
        X509AuthenticationToken token = (X509AuthenticationToken)authToken;
        if (!PkiRealm.isCertificateChainTrusted(this.trustManager, token, this.logger)) {
            listener.onResponse((Object)AuthenticationResult.unsuccessful("Certificate for " + token.dn() + " is not trusted", null));
        } else {
            Map<String, Object> metadata = Collections.singletonMap("pki_dn", token.dn());
            UserRoleMapper.UserData user = new UserRoleMapper.UserData(token.principal(), token.dn(), Collections.emptySet(), metadata, this.config);
            this.roleMapper.resolveRoles(user, (ActionListener<Set<String>>)ActionListener.wrap(roles -> listener.onResponse((Object)AuthenticationResult.success(new User(token.principal(), roles.toArray(new String[roles.size()]), null, null, metadata, true))), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    @Override
    public void lookupUser(String username, ActionListener<User> listener) {
        listener.onResponse(null);
    }

    static X509AuthenticationToken token(Object pkiHeaderValue, Pattern principalPattern, Logger logger) {
        if (pkiHeaderValue == null) {
            return null;
        }
        assert (pkiHeaderValue instanceof X509Certificate[]);
        X509Certificate[] certificates = (X509Certificate[])pkiHeaderValue;
        if (certificates.length == 0) {
            return null;
        }
        String dn = certificates[0].getSubjectX500Principal().toString();
        Matcher matcher = principalPattern.matcher(dn);
        if (!matcher.find()) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but could not extract principal from DN", (Object)dn);
            }
            return null;
        }
        String principal = matcher.group(1);
        if (Strings.isNullOrEmpty((String)principal)) {
            if (logger.isDebugEnabled()) {
                logger.debug("certificate authentication succeeded for [{}] but extracted principal was empty", (Object)dn);
            }
            return null;
        }
        return new X509AuthenticationToken(certificates, principal, dn);
    }

    static boolean isCertificateChainTrusted(X509TrustManager trustManager, X509AuthenticationToken token, Logger logger) {
        if (trustManager != null) {
            try {
                trustManager.checkClientTrusted(token.credentials(), AUTH_TYPE);
                return true;
            }
            catch (CertificateException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace(() -> new ParameterizedMessage("failed certificate validation for principal [{}]", (Object)token.principal()), (Throwable)e);
                } else if (logger.isDebugEnabled()) {
                    logger.debug("failed certificate validation for principal [{}]", (Object)token.principal());
                }
                return false;
            }
        }
        return true;
    }

    static X509TrustManager trustManagers(RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        Environment env = realmConfig.env();
        List certificateAuthorities = settings.getAsList(PkiRealm.SSL_SETTINGS.caPaths.getKey(), null);
        String truststorePath = ((Optional)PkiRealm.SSL_SETTINGS.truststorePath.get(settings)).orElse(null);
        if (truststorePath == null && certificateAuthorities == null) {
            return null;
        }
        if (truststorePath != null && certificateAuthorities != null) {
            String pathKey = RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.truststorePath);
            String caKey = RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.caPaths);
            throw new IllegalArgumentException("[" + pathKey + "] and [" + caKey + "] cannot be used at the same time");
        }
        if (truststorePath != null) {
            return PkiRealm.trustManagersFromTruststore(truststorePath, realmConfig);
        }
        return PkiRealm.trustManagersFromCAs(settings, env);
    }

    private static X509TrustManager trustManagersFromTruststore(String truststorePath, RealmConfig realmConfig) {
        Settings settings = realmConfig.settings();
        if (!PkiRealm.SSL_SETTINGS.truststorePassword.exists(settings) && !PkiRealm.SSL_SETTINGS.legacyTruststorePassword.exists(settings)) {
            throw new IllegalArgumentException("Neither [" + RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.truststorePassword) + "] or [" + RealmSettings.getFullSettingKey(realmConfig, PkiRealm.SSL_SETTINGS.legacyTruststorePassword) + "] is configured");
        }
        Throwable throwable = null;
        try (SecureString password = (SecureString)PkiRealm.SSL_SETTINGS.truststorePassword.get(settings);){
            String trustStoreAlgorithm = (String)PkiRealm.SSL_SETTINGS.truststoreAlgorithm.get(settings);
            String trustStoreType = SSLConfigurationSettings.getKeyStoreType(PkiRealm.SSL_SETTINGS.truststoreType, settings, truststorePath);
            try {
                X509ExtendedTrustManager x509ExtendedTrustManager = CertUtils.trustManager(truststorePath, trustStoreType, password.getChars(), trustStoreAlgorithm, realmConfig.env());
                return x509ExtendedTrustManager;
            }
            catch (Exception e) {
                try {
                    throw new IllegalArgumentException("failed to load specified truststore", e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static X509TrustManager trustManagersFromCAs(Settings settings, Environment env) {
        List certificateAuthorities = settings.getAsList(PkiRealm.SSL_SETTINGS.caPaths.getKey(), null);
        assert (certificateAuthorities != null);
        try {
            Certificate[] certificates = CertUtils.readCertificates(certificateAuthorities, env);
            return CertUtils.trustManager(certificates);
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load certificate authorities for PKI realm", (Throwable)e, new Object[0]);
        }
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(USERNAME_PATTERN_SETTING);
        settings.add(PkiRealm.SSL_SETTINGS.truststorePath);
        settings.add(PkiRealm.SSL_SETTINGS.truststorePassword);
        settings.add(PkiRealm.SSL_SETTINGS.legacyTruststorePassword);
        settings.add(PkiRealm.SSL_SETTINGS.truststoreAlgorithm);
        settings.add(PkiRealm.SSL_SETTINGS.caPaths);
        settings.addAll(CompositeRoleMapper.getSettings());
        return settings;
    }
}

