/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;

class SearchGroupsResolver
implements LdapSession.GroupsResolver {
    private static final String GROUP_SEARCH_DEFAULT_FILTER = "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))";
    static final Setting<String> BASE_DN = Setting.simpleString((String)"group_search.base_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<LdapSearchScope> SCOPE = new Setting("group_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> USER_ATTRIBUTE = Setting.simpleString((String)"group_search.user_attribute", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<String> FILTER = new Setting("group_search.filter", "(&(|(objectclass=groupOfNames)(objectclass=groupOfUniqueNames)(objectclass=group)(objectclass=posixGroup))(|(uniqueMember={0})(member={0})(memberUid={0})))", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    private final String baseDn;
    private final String filter;
    private final String userAttribute;
    private final LdapSearchScope scope;
    private final boolean ignoreReferralErrors;

    SearchGroupsResolver(Settings settings) {
        if (!BASE_DN.exists(settings)) {
            throw new IllegalArgumentException("base_dn must be specified");
        }
        this.baseDn = (String)BASE_DN.get(settings);
        this.filter = (String)FILTER.get(settings);
        this.userAttribute = (String)USER_ATTRIBUTE.get(settings);
        this.scope = (LdapSearchScope)((Object)SCOPE.get(settings));
        this.ignoreReferralErrors = (Boolean)SessionFactory.IGNORE_REFERRAL_ERRORS_SETTING.get(settings);
    }

    @Override
    public void resolve(LDAPInterface connection, String userDn, TimeValue timeout, Logger logger, Collection<Attribute> attributes, ActionListener<List<String>> listener) {
        this.getUserId(userDn, attributes, connection, timeout, (ActionListener<String>)ActionListener.wrap(userId -> {
            if (userId == null) {
                listener.onResponse(Collections.emptyList());
            } else {
                try {
                    Filter userFilter = LdapUtils.createFilter(this.filter, userId);
                    LdapUtils.search(connection, this.baseDn, this.scope.scope(), userFilter, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<List<SearchResultEntry>>)ActionListener.wrap(results -> listener.onResponse(results.stream().map(r -> r.getDN()).collect(Collectors.toList())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)), "1.1");
                }
                catch (LDAPException e) {
                    listener.onFailure((Exception)((Object)e));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public String[] attributes() {
        if (Strings.hasLength((String)this.userAttribute)) {
            return new String[]{this.userAttribute};
        }
        return null;
    }

    private void getUserId(String dn, Collection<Attribute> attributes, LDAPInterface connection, TimeValue timeout, ActionListener<String> listener) {
        if (Strings.isNullOrEmpty((String)this.userAttribute) || this.userAttribute.equals("dn")) {
            listener.onResponse((Object)dn);
        } else if (attributes != null) {
            String value = attributes.stream().filter(attribute -> attribute.getName().equals(this.userAttribute)).map(Attribute::getValue).findFirst().orElse(null);
            listener.onResponse((Object)value);
        } else {
            this.readUserAttribute(connection, dn, timeout, listener);
        }
    }

    void readUserAttribute(LDAPInterface connection, String userDn, TimeValue timeout, ActionListener<String> listener) {
        LdapUtils.searchForEntry(connection, userDn, SearchScope.BASE, LdapUtils.OBJECT_CLASS_PRESENCE_FILTER, Math.toIntExact(timeout.seconds()), this.ignoreReferralErrors, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null || !entry.hasAttribute(this.userAttribute)) {
                listener.onResponse(null);
            } else {
                listener.onResponse((Object)entry.getAttributeValue(this.userAttribute));
            }
        }, arg_0 -> listener.onFailure(arg_0)), this.userAttribute);
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.add(BASE_DN);
        settings.add(FILTER);
        settings.add(USER_ATTRIBUTE);
        settings.add(SCOPE);
        return settings;
    }
}

