/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPInterface;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SimpleBindRequest;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.PoolingSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.SearchGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.UserAttributeGroupsResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSearchScope;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CharArrays;
import org.elasticsearch.xpack.ssl.SSLService;

class LdapUserSearchSessionFactory
extends PoolingSessionFactory {
    private static final String DEFAULT_USERNAME_ATTRIBUTE = "uid";
    static final String SEARCH_PREFIX = "user_search.";
    static final Setting<String> SEARCH_ATTRIBUTE = new Setting("user_search.attribute", "uid", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private static final Setting<String> SEARCH_BASE_DN = Setting.simpleString((String)"user_search.base_dn", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<String> SEARCH_FILTER = Setting.simpleString((String)"user_search.filter", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<LdapSearchScope> SEARCH_SCOPE = new Setting("user_search.scope", (String)null, s -> LdapSearchScope.resolve(s, LdapSearchScope.SUB_TREE), new Setting.Property[]{Setting.Property.NodeScope});
    private static final Setting<Boolean> POOL_ENABLED = Setting.boolSetting((String)"user_search.pool.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final String userSearchBaseDn;
    private final LdapSearchScope scope;
    private final String searchFilter;

    LdapUserSearchSessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) throws LDAPException {
        super(config, sslService, LdapUserSearchSessionFactory.groupResolver(config.settings()), POOL_ENABLED, () -> LdapUserSearchSessionFactory.bindRequest(config.settings()), () -> {
            if (BIND_DN.exists(config.settings())) {
                return (String)BIND_DN.get(config.settings());
            }
            return (String)SEARCH_BASE_DN.get(config.settings());
        }, threadPool);
        Settings settings = config.settings();
        if (!SEARCH_BASE_DN.exists(settings)) {
            throw new IllegalArgumentException("[" + RealmSettings.getFullSettingKey(config, SEARCH_BASE_DN) + "] must be specified");
        }
        this.userSearchBaseDn = (String)SEARCH_BASE_DN.get(settings);
        this.scope = (LdapSearchScope)((Object)SEARCH_SCOPE.get(settings));
        this.searchFilter = LdapUserSearchSessionFactory.getSearchFilter(config);
        this.logger.info("Realm [{}] is in user-search mode - base_dn=[{}], search filter=[{}]", (Object)config.name(), (Object)this.userSearchBaseDn, (Object)this.searchFilter);
    }

    static SimpleBindRequest bindRequest(Settings settings) {
        if (BIND_DN.exists(settings)) {
            return new SimpleBindRequest((String)BIND_DN.get(settings), (String)BIND_PASSWORD.get(settings));
        }
        return new SimpleBindRequest();
    }

    static boolean hasUserSearchSettings(RealmConfig config) {
        return !config.settings().getByPrefix(SEARCH_PREFIX).isEmpty();
    }

    @Override
    void getSessionWithPool(final LDAPConnectionPool connectionPool, String user, SecureString password, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                final String dn = entry.getDN();
                byte[] passwordBytes = CharArrays.toUtf8Bytes(password.getChars());
                SimpleBindRequest bind = new SimpleBindRequest(dn, passwordBytes);
                LdapUtils.maybeForkThenBind((LDAPInterface)connectionPool, (BindRequest)bind, this.threadPool, (AbstractRunnable)new ActionRunnable<LdapSession>(listener){

                    protected void doRun() throws Exception {
                        this.listener.onResponse((Object)new LdapSession(LdapUserSearchSessionFactory.this.logger, LdapUserSearchSessionFactory.this.config, (LDAPInterface)connectionPool, dn, LdapUserSearchSessionFactory.this.groupResolver, LdapUserSearchSessionFactory.this.metaDataResolver, LdapUserSearchSessionFactory.this.timeout, entry.getAttributes()));
                    }

                    public void onFailure(Exception e) {
                        this.listener.onFailure(e);
                    }
                });
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getSessionWithoutPool(final String user, final SecureString password, final ActionListener<LdapSession> listener) {
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            SimpleBindRequest bind = LdapUserSearchSessionFactory.bindRequest(this.config.settings());
            LdapUtils.maybeForkThenBind((LDAPInterface)connection, (BindRequest)bind, this.threadPool, new AbstractRunnable(){

                protected void doRun() throws Exception {
                    LdapUserSearchSessionFactory.this.findUser(user, (LDAPInterface)connection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable[])new Closeable[]{connection});
                            listener.onResponse(null);
                        } else {
                            final String dn = entry.getDN();
                            byte[] passwordBytes = CharArrays.toUtf8Bytes(password.getChars());
                            SimpleBindRequest userBind = new SimpleBindRequest(dn, passwordBytes);
                            LdapUtils.maybeForkThenBind((LDAPInterface)connection, (BindRequest)userBind, LdapUserSearchSessionFactory.this.threadPool, new AbstractRunnable((SearchResultEntry)entry){
                                final /* synthetic */ SearchResultEntry val$entry;
                                {
                                    this.val$entry = searchResultEntry;
                                }

                                protected void doRun() throws Exception {
                                    listener.onResponse((Object)new LdapSession(LdapUserSearchSessionFactory.this.logger, LdapUserSearchSessionFactory.this.config, (LDAPInterface)connection, dn, LdapUserSearchSessionFactory.this.groupResolver, LdapUserSearchSessionFactory.this.metaDataResolver, LdapUserSearchSessionFactory.this.timeout, this.val$entry.getAttributes()));
                                }

                                public void onFailure(Exception e) {
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                                    listener.onFailure(e);
                                }
                            });
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }));
                }

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    @Override
    public boolean supportsUnauthenticatedSession() {
        return true;
    }

    @Override
    void getUnauthenticatedSessionWithPool(LDAPConnectionPool connectionPool, String user, ActionListener<LdapSession> listener) {
        this.findUser(user, (LDAPInterface)connectionPool, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
            if (entry == null) {
                listener.onResponse(null);
            } else {
                String dn = entry.getDN();
                LdapSession session = new LdapSession(this.logger, this.config, (LDAPInterface)connectionPool, dn, this.groupResolver, this.metaDataResolver, this.timeout, entry.getAttributes());
                listener.onResponse((Object)session);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    void getUnauthenticatedSessionWithoutPool(final String user, final ActionListener<LdapSession> listener) {
        try {
            final LDAPConnection connection = (LDAPConnection)LdapUtils.privilegedConnect(() -> ((ServerSet)this.serverSet).getConnection());
            SimpleBindRequest bind = LdapUserSearchSessionFactory.bindRequest(this.config.settings());
            LdapUtils.maybeForkThenBind((LDAPInterface)connection, (BindRequest)bind, this.threadPool, new AbstractRunnable(){

                protected void doRun() throws Exception {
                    LdapUserSearchSessionFactory.this.findUser(user, (LDAPInterface)connection, (ActionListener<SearchResultEntry>)ActionListener.wrap(entry -> {
                        if (entry == null) {
                            IOUtils.close((Closeable[])new Closeable[]{connection});
                            listener.onResponse(null);
                        } else {
                            listener.onResponse((Object)new LdapSession(LdapUserSearchSessionFactory.this.logger, LdapUserSearchSessionFactory.this.config, (LDAPInterface)connection, entry.getDN(), LdapUserSearchSessionFactory.this.groupResolver, LdapUserSearchSessionFactory.this.metaDataResolver, LdapUserSearchSessionFactory.this.timeout, entry.getAttributes()));
                        }
                    }, e -> {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                        listener.onFailure(e);
                    }));
                }

                public void onFailure(Exception e) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{connection});
                    listener.onFailure(e);
                }
            });
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
        }
    }

    private void findUser(String user, LDAPInterface ldapInterface, ActionListener<SearchResultEntry> listener) {
        Filter filter;
        try {
            filter = LdapUtils.createFilter(this.searchFilter, user);
        }
        catch (LDAPException e) {
            listener.onFailure((Exception)((Object)e));
            return;
        }
        LdapUtils.searchForEntry(ldapInterface, this.userSearchBaseDn, this.scope.scope(), filter, Math.toIntExact(this.timeout.seconds()), this.ignoreReferralErrors, listener, LdapUtils.attributesToSearchFor(this.groupResolver.attributes(), this.metaDataResolver.attributeNames()));
    }

    private static LdapSession.GroupsResolver groupResolver(Settings settings) {
        if (SearchGroupsResolver.BASE_DN.exists(settings)) {
            return new SearchGroupsResolver(settings);
        }
        return new UserAttributeGroupsResolver(settings);
    }

    static String getSearchFilter(RealmConfig config) {
        Settings settings = config.settings();
        boolean hasAttribute = SEARCH_ATTRIBUTE.exists(settings);
        boolean hasFilter = SEARCH_FILTER.exists(settings);
        if (hasAttribute && hasFilter) {
            throw new IllegalArgumentException("search attribute setting [" + RealmSettings.getFullSettingKey(config, SEARCH_ATTRIBUTE) + "] and filter setting [" + RealmSettings.getFullSettingKey(config, SEARCH_FILTER) + "] cannot be combined!");
        }
        if (hasFilter) {
            return (String)SEARCH_FILTER.get(settings);
        }
        if (hasAttribute) {
            return "(" + (String)SEARCH_ATTRIBUTE.get(settings) + "={0})";
        }
        return "(uid={0})";
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(SessionFactory.getSettings());
        settings.addAll(PoolingSessionFactory.getSettings());
        settings.add(SEARCH_BASE_DN);
        settings.add(SEARCH_SCOPE);
        settings.add(SEARCH_ATTRIBUTE);
        settings.add(POOL_ENABLED);
        settings.add(SEARCH_FILTER);
        settings.addAll(SearchGroupsResolver.getSettings());
        settings.addAll(UserAttributeGroupsResolver.getSettings());
        return settings;
    }
}

