/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap;

import com.unboundid.ldap.sdk.LDAPException;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.authc.ldap.ActiveDirectorySessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.LdapUserSearchSessionFactory;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapMetaDataResolver;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;
import org.elasticsearch.xpack.security.authc.ldap.support.SessionFactory;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.support.mapper.CompositeRoleMapper;
import org.elasticsearch.xpack.security.authc.support.mapper.NativeRoleMappingStore;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.ssl.SSLService;

public final class LdapRealm
extends CachingUsernamePasswordRealm {
    public static final String LDAP_TYPE = "ldap";
    public static final String AD_TYPE = "active_directory";
    static final Setting<TimeValue> EXECUTION_TIMEOUT = Setting.timeSetting((String)"timeout.execution", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final SessionFactory sessionFactory;
    private final UserRoleMapper roleMapper;
    private final ThreadPool threadPool;
    private final TimeValue executionTimeout;

    public LdapRealm(String type, RealmConfig config, SSLService sslService, ResourceWatcherService watcherService, NativeRoleMappingStore nativeRoleMappingStore, ThreadPool threadPool) throws LDAPException {
        this(type, config, LdapRealm.sessionFactory(config, sslService, threadPool, type), new CompositeRoleMapper(type, config, watcherService, nativeRoleMappingStore), threadPool);
    }

    LdapRealm(String type, RealmConfig config, SessionFactory sessionFactory, UserRoleMapper roleMapper, ThreadPool threadPool) {
        super(type, config);
        this.sessionFactory = sessionFactory;
        this.roleMapper = roleMapper;
        this.threadPool = threadPool;
        this.executionTimeout = (TimeValue)EXECUTION_TIMEOUT.get(config.settings());
        roleMapper.refreshRealmOnChange(this);
    }

    static SessionFactory sessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool, String type) throws LDAPException {
        SessionFactory sessionFactory;
        if (AD_TYPE.equals(type)) {
            sessionFactory = new ActiveDirectorySessionFactory(config, sslService, threadPool);
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [" + "active_directory" + ", " + "ldap" + "]";
            boolean hasSearchSettings = LdapUserSearchSessionFactory.hasUserSearchSettings(config);
            boolean hasTemplates = LdapSessionFactory.USER_DN_TEMPLATES_SETTING.exists(config.settings());
            if (!hasSearchSettings) {
                if (!hasTemplates) {
                    throw new IllegalArgumentException("settings were not found for either user search [" + RealmSettings.getFullSettingKey(config, "user_search.") + "] or user template [" + RealmSettings.getFullSettingKey(config, LdapSessionFactory.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please provide the settings for the mode you wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapSessionFactory(config, sslService, threadPool);
            } else {
                if (hasTemplates) {
                    throw new IllegalArgumentException("settings were found for both user search [" + RealmSettings.getFullSettingKey(config, "user_search.") + "] and user template [" + RealmSettings.getFullSettingKey(config, LdapSessionFactory.USER_DN_TEMPLATES_SETTING) + "] modes of operation. Please remove the settings for the mode you do not wish to use. For more details refer to the ldap authentication section of the X-Pack guide.");
                }
                sessionFactory = new LdapUserSearchSessionFactory(config, sslService, threadPool);
            }
        }
        return sessionFactory;
    }

    public static Set<Setting<?>> getSettings(String type) {
        HashSet settings = new HashSet();
        settings.addAll(CachingUsernamePasswordRealm.getCachingSettings());
        settings.addAll(CompositeRoleMapper.getSettings());
        settings.add(EXECUTION_TIMEOUT);
        if (AD_TYPE.equals(type)) {
            settings.addAll(ActiveDirectorySessionFactory.getSettings());
        } else {
            assert (LDAP_TYPE.equals(type)) : "type [" + type + "] is unknown. expected one of [" + "active_directory" + ", " + "ldap" + "]";
            settings.addAll(LdapSessionFactory.getSettings());
            settings.addAll(LdapUserSearchSessionFactory.getSettings());
        }
        settings.addAll(LdapMetaDataResolver.getSettings());
        return settings;
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        CancellableLdapRunnable<AuthenticationResult> cancellableLdapRunnable = new CancellableLdapRunnable<AuthenticationResult>(listener, ex -> AuthenticationResult.unsuccessful("Authentication against realm [" + this.toString() + "] failed", ex), () -> this.sessionFactory.session(token.principal(), token.credentials(), (ActionListener<LdapSession>)this.contextPreservingListener(new LdapSessionActionListener("authenticate", token.principal(), listener))), this.logger);
        this.threadPool.generic().execute((Runnable)((Object)cancellableLdapRunnable));
        this.threadPool.schedule(this.executionTimeout, "same", cancellableLdapRunnable::maybeTimeout);
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> userActionListener) {
        if (this.sessionFactory.supportsUnauthenticatedSession()) {
            ActionListener sessionListener = ActionListener.wrap(result -> userActionListener.onResponse((Object)result.getUser()), arg_0 -> userActionListener.onFailure(arg_0));
            CancellableLdapRunnable<User> cancellableLdapRunnable = new CancellableLdapRunnable<User>(userActionListener, e -> null, () -> this.sessionFactory.unauthenticatedSession(username, (ActionListener<LdapSession>)this.contextPreservingListener(new LdapSessionActionListener("lookup", username, (ActionListener<AuthenticationResult>)sessionListener))), this.logger);
            this.threadPool.generic().execute((Runnable)((Object)cancellableLdapRunnable));
            this.threadPool.schedule(this.executionTimeout, "same", cancellableLdapRunnable::maybeTimeout);
        } else {
            userActionListener.onResponse(null);
        }
    }

    private ContextPreservingActionListener<LdapSession> contextPreservingListener(LdapSessionActionListener sessionListener) {
        Supplier toRestore = this.config.threadContext().newRestorableContext(false);
        return new ContextPreservingActionListener(toRestore, (ActionListener)sessionListener);
    }

    @Override
    public Map<String, Object> usageStats() {
        Map<String, Object> usage = super.usageStats();
        usage.put("load_balance_type", LdapLoadBalancing.resolve(this.config.settings()).toString());
        usage.put("ssl", this.sessionFactory.isSslUsed());
        usage.put("user_search", LdapUserSearchSessionFactory.hasUserSearchSettings(this.config));
        return usage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildUser(LdapSession session, String username, ActionListener<AuthenticationResult> listener, UserRoleMapper roleMapper) {
        if (session == null) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
        } else {
            boolean loadingGroups = false;
            try {
                Consumer<Exception> onFailure = e -> {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{session});
                    listener.onFailure(e);
                };
                session.resolve((ActionListener<LdapSession.LdapUserData>)ActionListener.wrap(ldapData -> {
                    Map metadata = MapBuilder.newMapBuilder().put((Object)"ldap_dn", (Object)session.userDn()).put((Object)"ldap_groups", ldapData.groups).putAll(ldapData.metaData).map();
                    UserRoleMapper.UserData user = new UserRoleMapper.UserData(username, session.userDn(), ldapData.groups, metadata, session.realm());
                    roleMapper.resolveRoles(user, (ActionListener<Set<String>>)ActionListener.wrap(roles -> {
                        IOUtils.close((Closeable[])new Closeable[]{session});
                        String[] rolesArray = roles.toArray(new String[roles.size()]);
                        listener.onResponse((Object)AuthenticationResult.success(new User(username, rolesArray, null, null, metadata, true)));
                    }, (Consumer)onFailure));
                }, onFailure));
                loadingGroups = true;
            }
            finally {
                if (!loadingGroups) {
                    session.close();
                }
            }
        }
    }

    static class CancellableLdapRunnable<T>
    extends AbstractRunnable {
        private final Runnable in;
        private final ActionListener<T> listener;
        private final Function<Exception, T> defaultValue;
        private final Logger logger;
        private final AtomicReference<LdapRunnableState> state = new AtomicReference<LdapRunnableState>(LdapRunnableState.AWAITING_EXECUTION);

        CancellableLdapRunnable(ActionListener<T> listener, Function<Exception, T> defaultValue, Runnable in, Logger logger) {
            this.listener = listener;
            this.defaultValue = Objects.requireNonNull(defaultValue);
            this.in = in;
            this.logger = logger;
        }

        public void onFailure(Exception e) {
            this.logger.error("execution of ldap runnable failed", (Throwable)e);
            T result = this.defaultValue.apply(e);
            this.listener.onResponse(result);
        }

        protected void doRun() throws Exception {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.EXECUTING)) {
                this.in.run();
            } else {
                this.logger.trace("skipping execution of ldap runnable as the current state is [{}]", (Object)this.state.get());
            }
        }

        public void onRejection(Exception e) {
            this.listener.onFailure(e);
        }

        void maybeTimeout() {
            if (this.state.compareAndSet(LdapRunnableState.AWAITING_EXECUTION, LdapRunnableState.TIMED_OUT)) {
                this.logger.warn("skipping execution of ldap runnable as it has been waiting for execution too long");
                this.listener.onFailure((Exception)new ElasticsearchTimeoutException("timed out waiting for execution of ldap runnable", new Object[0]));
            }
        }

        static enum LdapRunnableState {
            AWAITING_EXECUTION,
            EXECUTING,
            TIMED_OUT;

        }
    }

    private class LdapSessionActionListener
    implements ActionListener<LdapSession> {
        private final AtomicReference<LdapSession> ldapSessionAtomicReference = new AtomicReference();
        private String action;
        private final String username;
        private final ActionListener<AuthenticationResult> resultListener;

        LdapSessionActionListener(String action, String username, ActionListener<AuthenticationResult> resultListener) {
            this.action = action;
            this.username = username;
            this.resultListener = resultListener;
        }

        public void onResponse(LdapSession session) {
            if (session == null) {
                this.resultListener.onResponse((Object)AuthenticationResult.notHandled());
            } else {
                this.ldapSessionAtomicReference.set(session);
                LdapRealm.buildUser(session, this.username, (ActionListener<AuthenticationResult>)this.resultListener, LdapRealm.this.roleMapper);
            }
        }

        public void onFailure(Exception e) {
            if (this.ldapSessionAtomicReference.get() != null) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)((Object)this.ldapSessionAtomicReference.get())});
            }
            if (LdapRealm.this.logger.isDebugEnabled()) {
                LdapRealm.this.logger.debug((Message)new ParameterizedMessage("Exception occurred during {} for {}", (Object)this.action, (Object)LdapRealm.this), (Throwable)e);
            }
            this.resultListener.onResponse((Object)AuthenticationResult.unsuccessful(this.action + " failed", e));
        }
    }
}

