/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.engine.DocumentMissingException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.security.ScrollHelper;
import org.elasticsearch.xpack.security.SecurityLifecycleService;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.security.action.realm.ClearRealmCacheResponse;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.security.action.user.DeleteUserRequest;
import org.elasticsearch.xpack.security.action.user.PutUserRequest;
import org.elasticsearch.xpack.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;
import org.elasticsearch.xpack.security.authc.esnative.UserAndPassword;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.client.SecurityClient;
import org.elasticsearch.xpack.security.user.User;

public class NativeUsersStore
extends AbstractComponent {
    public static final String INDEX_TYPE = "doc";
    static final String USER_DOC_TYPE = "user";
    public static final String RESERVED_USER_TYPE = "reserved-user";
    private final Hasher hasher = Hasher.BCRYPT;
    private final Client client;
    private final boolean isTribeNode;
    private volatile SecurityLifecycleService securityLifecycleService;

    public NativeUsersStore(Settings settings, Client client, SecurityLifecycleService securityLifecycleService) {
        super(settings);
        this.client = client;
        this.isTribeNode = XPackPlugin.isTribeNode(settings);
        this.securityLifecycleService = securityLifecycleService;
    }

    public void getUser(String username, ActionListener<User> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse((Object)(uap == null ? null : uap.user())), arg_0 -> listener.onFailure(arg_0)));
    }

    public void getUsers(String[] userNames, ActionListener<Collection<User>> listener) {
        Consumer<Exception> handleException = t -> {
            if (t instanceof IndexNotFoundException) {
                this.logger.trace("could not retrieve users because security index does not exist");
                listener.onResponse(Collections.emptyList());
            } else {
                listener.onFailure(t);
            }
        };
        if (userNames.length == 1) {
            String username = userNames[0];
            this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(uap -> listener.onResponse(uap == null ? Collections.emptyList() : Collections.singletonList(uap.user())), handleException::accept));
        } else {
            if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
                listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
                return;
            }
            try {
                TermQueryBuilder query;
                if (userNames == null || userNames.length == 0) {
                    query = QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)USER_DOC_TYPE);
                } else {
                    String[] users = (String[])Arrays.asList(userNames).stream().map(s -> NativeUsersStore.getIdForUser(USER_DOC_TYPE, s)).toArray(String[]::new);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{INDEX_TYPE}).addIds(users));
                }
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin(this.client.threadPool().getThreadContext(), "security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll(TimeValue.timeValueSeconds((long)10L)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity(this.client, request, new ContextPreservingActionListener(supplier, listener), hit -> {
                        UserAndPassword u = this.transformUser(hit.getId(), hit.getSourceAsMap());
                        return u != null ? u.user() : null;
                    });
                }
            }
            catch (Exception e) {
                this.logger.error((Message)new ParameterizedMessage("unable to retrieve users {}", (Object)Arrays.toString(userNames)), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private void getUserAndPassword(final String user, final ActionListener<UserAndPassword> listener) {
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        try {
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", this.client.prepareGet(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, user)).request(), new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    listener.onResponse((Object)NativeUsersStore.this.transformUser(response.getId(), response.getSource()));
                }

                public void onFailure(Exception t) {
                    if (t instanceof IndexNotFoundException) {
                        NativeUsersStore.this.logger.trace(() -> new ParameterizedMessage("could not retrieve user [{}] because security index does not exist", (Object)user), (Throwable)t);
                    } else {
                        NativeUsersStore.this.logger.error((Message)new ParameterizedMessage("failed to retrieve user [{}]", (Object)user), (Throwable)t);
                    }
                    listener.onResponse(null);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
        }
        catch (IndexNotFoundException infe) {
            this.logger.trace(() -> new ParameterizedMessage("could not retrieve user [{}] because security index does not exist", (Object)user));
            listener.onResponse(null);
        }
        catch (Exception e) {
            this.logger.error((Message)new ParameterizedMessage("unable to retrieve user [{}]", (Object)user), (Throwable)e);
            listener.onFailure(e);
        }
    }

    public void changePassword(final ChangePasswordRequest request, final ActionListener<Void> listener) {
        final String username = request.username();
        assert (!"_system".equals(username) && !"_xpack".equals(username)) : username + "is internal!";
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("password cannot be changed as user service cannot write until template and mappings are up to date"));
            return;
        }
        final String docType = ReservedRealm.isReserved(username, this.settings) ? RESERVED_USER_TYPE : USER_DOC_TYPE;
        this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((UpdateRequestBuilder)this.client.prepareUpdate(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(docType, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(request.passwordHash())}).setRefreshPolicy(request.getRefreshPolicy())).request(), new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED);
                NativeUsersStore.this.clearRealmCache(request.username(), listener, null);
            }

            public void onFailure(Exception e) {
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    if (docType.equals(NativeUsersStore.RESERVED_USER_TYPE)) {
                        NativeUsersStore.this.createReservedUser(username, request.passwordHash(), request.getRefreshPolicy(), (ActionListener<Void>)listener);
                    } else {
                        NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to change password for user [{}]", (Object)request.username()), (Throwable)e);
                        ValidationException validationException = new ValidationException();
                        validationException.addValidationError("user must exist in order to change password");
                        listener.onFailure((Exception)validationException);
                    }
                } else {
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    private void createReservedUser(final String username, char[] passwordHash, WriteRequest.RefreshPolicy refresh, final ActionListener<Void> listener) {
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((IndexRequestBuilder)this.client.prepareIndex(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).setSource(new Object[]{User.Fields.PASSWORD.getPreferredName(), String.valueOf(passwordHash), User.Fields.ENABLED.getPreferredName(), true, User.Fields.TYPE.getPreferredName(), RESERVED_USER_TYPE}).setRefreshPolicy(refresh)).request(), new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                NativeUsersStore.this.clearRealmCache(username, listener, null);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
    }

    public void putUser(PutUserRequest request, ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("user cannot be created or changed as the user service cannot write until template and mappings are up to date"));
            return;
        }
        try {
            if (request.passwordHash() == null) {
                this.updateUserWithoutPassword(request, listener);
            } else {
                this.indexUser(request, listener);
            }
        }
        catch (Exception e) {
            this.logger.error((Message)new ParameterizedMessage("unable to put user [{}]", (Object)request.username()), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void updateUserWithoutPassword(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() == null);
        assert (!this.securityLifecycleService.isSecurityIndexOutOfDate()) : "security index should be up to date";
        this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((UpdateRequestBuilder)this.client.prepareUpdate(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username())).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled(), User.Fields.TYPE.getPreferredName(), USER_DOC_TYPE}).setRefreshPolicy(putUserRequest.getRefreshPolicy())).request(), new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                assert (updateResponse.getResult() == DocWriteResponse.Result.UPDATED);
                NativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, false);
            }

            public void onFailure(Exception e) {
                Exception failure = e;
                if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                    NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to update user document with username [{}]", (Object)putUserRequest.username()), (Throwable)e);
                    ValidationException validationException = new ValidationException();
                    validationException.addValidationError("password must be specified unless you are updating an existing user");
                    failure = validationException;
                }
                listener.onFailure(failure);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
    }

    private void indexUser(final PutUserRequest putUserRequest, final ActionListener<Boolean> listener) {
        assert (putUserRequest.passwordHash() != null);
        assert (!this.securityLifecycleService.isSecurityIndexOutOfDate()) : "security index should be up to date";
        this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((IndexRequestBuilder)this.client.prepareIndex(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, putUserRequest.username())).setSource(new Object[]{User.Fields.USERNAME.getPreferredName(), putUserRequest.username(), User.Fields.PASSWORD.getPreferredName(), String.valueOf(putUserRequest.passwordHash()), User.Fields.ROLES.getPreferredName(), putUserRequest.roles(), User.Fields.FULL_NAME.getPreferredName(), putUserRequest.fullName(), User.Fields.EMAIL.getPreferredName(), putUserRequest.email(), User.Fields.METADATA.getPreferredName(), putUserRequest.metadata(), User.Fields.ENABLED.getPreferredName(), putUserRequest.enabled(), User.Fields.TYPE.getPreferredName(), USER_DOC_TYPE}).setRefreshPolicy(putUserRequest.getRefreshPolicy())).request(), new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse updateResponse) {
                NativeUsersStore.this.clearRealmCache(putUserRequest.username(), listener, updateResponse.getResult() == DocWriteResponse.Result.CREATED);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1)));
    }

    public void setEnabled(String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, ActionListener<Void> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be created or modified using a tribe node"));
            return;
        }
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("enabled status cannot be changed as user service cannot write until template and mappings are up to date"));
            return;
        }
        if (ReservedRealm.isReserved(username, this.settings)) {
            this.setReservedUserEnabled(username, enabled, refreshPolicy, true, listener);
        } else {
            this.setRegularUserEnabled(username, enabled, refreshPolicy, listener);
        }
    }

    private void setRegularUserEnabled(final String username, final boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, final ActionListener<Void> listener) {
        assert (!this.securityLifecycleService.isSecurityIndexOutOfDate()) : "security index should be up to date";
        try {
            this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((UpdateRequestBuilder)this.client.prepareUpdate(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setRefreshPolicy(refreshPolicy)).request(), new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    NativeUsersStore.this.clearRealmCache(username, listener, null);
                }

                public void onFailure(Exception e) {
                    Exception failure = e;
                    if (NativeUsersStore.isIndexNotFoundOrDocumentMissing(e)) {
                        NativeUsersStore.this.logger.debug(() -> new ParameterizedMessage("failed to {} user [{}]", (Object)(enabled ? "enable" : "disable"), (Object)username), (Throwable)e);
                        ValidationException validationException = new ValidationException();
                        validationException.addValidationError("only existing users can be " + (enabled ? "enabled" : "disabled"));
                        failure = validationException;
                    }
                    listener.onFailure(failure);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void setReservedUserEnabled(final String username, boolean enabled, WriteRequest.RefreshPolicy refreshPolicy, final boolean clearCache, final ActionListener<Void> listener) {
        assert (!this.securityLifecycleService.isSecurityIndexOutOfDate()) : "security index should be up to date";
        try {
            this.securityLifecycleService.createIndexIfNeededThenExecute(listener, () -> ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", ((UpdateRequestBuilder)this.client.prepareUpdate(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).setDoc(Requests.INDEX_CONTENT_TYPE, new Object[]{User.Fields.ENABLED.getPreferredName(), enabled}).setUpsert(XContentType.JSON, new Object[]{User.Fields.PASSWORD.getPreferredName(), "", User.Fields.ENABLED.getPreferredName(), enabled, User.Fields.TYPE.getPreferredName(), RESERVED_USER_TYPE}).setRefreshPolicy(refreshPolicy)).request(), new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse updateResponse) {
                    if (clearCache) {
                        NativeUsersStore.this.clearRealmCache(username, listener, null);
                    } else {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).update(arg_0, arg_1)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void deleteUser(final DeleteUserRequest deleteUserRequest, final ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("users may not be deleted using a tribe node"));
            return;
        }
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        if (!this.securityLifecycleService.isSecurityIndexWriteable()) {
            listener.onFailure((Exception)new IllegalStateException("user cannot be deleted as user service cannot write until template and mappings are up to date"));
            return;
        }
        try {
            DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(USER_DOC_TYPE, deleteUserRequest.username())).request();
            request.indicesOptions().ignoreUnavailable();
            request.setRefreshPolicy(deleteUserRequest.getRefreshPolicy());
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", request, new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    NativeUsersStore.this.clearRealmCache(deleteUserRequest.username(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
        }
        catch (Exception e) {
            this.logger.error("unable to remove user", (Throwable)e);
            listener.onFailure(e);
        }
    }

    void verifyPassword(String username, SecureString password, ActionListener<AuthenticationResult> listener) {
        this.getUserAndPassword(username, (ActionListener<UserAndPassword>)ActionListener.wrap(userAndPassword -> {
            if (userAndPassword == null || userAndPassword.passwordHash() == null) {
                listener.onResponse((Object)AuthenticationResult.notHandled());
            } else if (this.hasher.verify(password, userAndPassword.passwordHash())) {
                listener.onResponse((Object)AuthenticationResult.success(userAndPassword.user()));
            } else {
                listener.onResponse((Object)AuthenticationResult.unsuccessful("Password authentication failed for " + username, null));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    void getReservedUserInfo(final String username, final ActionListener<ReservedUserInfo> listener) {
        if (!this.securityLifecycleService.isSecurityIndexExisting()) {
            listener.onFailure((Exception)new IllegalStateException("Attempt to get reserved user info but the security index does not exist"));
            return;
        }
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm not be operational until the upgrade API is run on the security index"));
            return;
        }
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", this.client.prepareGet(".security", INDEX_TYPE, NativeUsersStore.getIdForUser(RESERVED_USER_TYPE, username)).request(), new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                if (getResponse.isExists()) {
                    Map sourceMap = getResponse.getSourceAsMap();
                    String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                    Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                    if (password == null) {
                        listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                    } else if (enabled == null) {
                        listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                    } else if (password.isEmpty()) {
                        listener.onResponse((Object)(enabled != false ? ReservedRealm.ENABLED_DEFAULT_USER_INFO : ReservedRealm.DISABLED_DEFAULT_USER_INFO).deepClone());
                    } else {
                        listener.onResponse((Object)new ReservedUserInfo(password.toCharArray(), enabled, false));
                    }
                } else {
                    listener.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    NativeUsersStore.this.logger.trace(() -> new ParameterizedMessage("could not retrieve built in user [{}] info since security index does not exist", (Object)username), (Throwable)e);
                    listener.onResponse(null);
                } else {
                    NativeUsersStore.this.logger.error((Message)new ParameterizedMessage("failed to retrieve built in user [{}] info", (Object)username), (Throwable)e);
                    listener.onFailure(null);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1));
    }

    void getAllReservedUserInfo(final ActionListener<Map<String, ReservedUserInfo>> listener) {
        if (this.securityLifecycleService.isSecurityIndexOutOfDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)User.Fields.TYPE.getPreferredName(), (String)RESERVED_USER_TYPE)).setFetchSource(true).request(), new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                HashMap<String, ReservedUserInfo> userInfos = new HashMap<String, ReservedUserInfo>();
                assert (searchResponse.getHits().getTotalHits() <= 10L) : "there are more than 10 reserved users we need to change this to retrieve them all!";
                for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                    Map sourceMap = searchHit.getSourceAsMap();
                    String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
                    Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
                    String id = searchHit.getId();
                    assert (id != null && id.startsWith(NativeUsersStore.RESERVED_USER_TYPE)) : "id [" + id + "] does not start with reserved-user prefix";
                    String username = id.substring(NativeUsersStore.RESERVED_USER_TYPE.length() + 1);
                    if (password == null) {
                        listener.onFailure((Exception)new IllegalStateException("password hash must not be null!"));
                        return;
                    }
                    if (enabled == null) {
                        listener.onFailure((Exception)new IllegalStateException("enabled must not be null!"));
                        return;
                    }
                    userInfos.put(username, new ReservedUserInfo(password.toCharArray(), enabled, false));
                }
                listener.onResponse(userInfos);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    NativeUsersStore.this.logger.trace("could not retrieve built in users since security index does not exist", (Throwable)e);
                    listener.onResponse(Collections.emptyMap());
                } else {
                    NativeUsersStore.this.logger.error("failed to retrieve built in users", (Throwable)e);
                    listener.onFailure(e);
                }
            }
        }, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1));
    }

    private <Response> void clearRealmCache(final String username, final ActionListener<Response> listener, final Response response) {
        SecurityClient securityClient = new SecurityClient((ElasticsearchClient)this.client);
        ClearRealmCacheRequest request = (ClearRealmCacheRequest)securityClient.prepareClearRealmCache().usernames(username).request();
        ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "security", request, new ActionListener<ClearRealmCacheResponse>(){

            public void onResponse(ClearRealmCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                NativeUsersStore.this.logger.error((Message)new ParameterizedMessage("unable to clear realm cache for user [{}]", (Object)username), (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + username + "] failed. please clear the realm cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)exception);
            }
        }, securityClient::clearRealmCache);
    }

    @Nullable
    private UserAndPassword transformUser(String id, Map<String, Object> sourceMap) {
        if (sourceMap == null) {
            return null;
        }
        assert (id != null && id.startsWith(USER_DOC_TYPE)) : "id [" + id + "] does not start with user prefix";
        String username = id.substring(USER_DOC_TYPE.length() + 1);
        try {
            String password = (String)sourceMap.get(User.Fields.PASSWORD.getPreferredName());
            String[] roles = ((List)sourceMap.get(User.Fields.ROLES.getPreferredName())).toArray(Strings.EMPTY_ARRAY);
            String fullName = (String)sourceMap.get(User.Fields.FULL_NAME.getPreferredName());
            String email = (String)sourceMap.get(User.Fields.EMAIL.getPreferredName());
            Boolean enabled = (Boolean)sourceMap.get(User.Fields.ENABLED.getPreferredName());
            if (enabled == null) {
                enabled = Boolean.TRUE;
            }
            Map metadata = (Map)sourceMap.get(User.Fields.METADATA.getPreferredName());
            return new UserAndPassword(new User(username, roles, fullName, email, metadata, enabled), password.toCharArray());
        }
        catch (Exception e) {
            this.logger.error((Message)new ParameterizedMessage("error in the format of data for user [{}]", (Object)username), (Throwable)e);
            return null;
        }
    }

    private static boolean isIndexNotFoundOrDocumentMissing(Exception e) {
        Throwable cause;
        return e instanceof ElasticsearchException && ((cause = ExceptionsHelper.unwrapCause((Throwable)e)) instanceof IndexNotFoundException || cause instanceof DocumentMissingException);
    }

    public static String getIdForUser(String docType, String userName) {
        return docType + "-" + userName;
    }

    static final class ReservedUserInfo {
        public final char[] passwordHash;
        public final boolean enabled;
        public final boolean hasEmptyPassword;

        ReservedUserInfo(char[] passwordHash, boolean enabled, boolean hasEmptyPassword) {
            this.passwordHash = passwordHash;
            this.enabled = enabled;
            this.hasEmptyPassword = hasEmptyPassword;
        }

        ReservedUserInfo deepClone() {
            return new ReservedUserInfo(Arrays.copyOf(this.passwordHash, this.passwordHash.length), this.enabled, this.hasEmptyPassword);
        }
    }
}

