/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.esnative;

import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.xpack.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.support.CachingUsernamePasswordRealm;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.user.User;

public class NativeRealm
extends CachingUsernamePasswordRealm {
    public static final String TYPE = "native";
    private final NativeUsersStore userStore;

    public NativeRealm(RealmConfig config, NativeUsersStore usersStore) {
        super(TYPE, config);
        this.userStore = usersStore;
    }

    @Override
    protected void doLookupUser(String username, ActionListener<User> listener) {
        this.userStore.getUser(username, listener);
    }

    @Override
    protected void doAuthenticate(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        this.userStore.verifyPassword(token.principal(), token.credentials(), listener);
    }

    public void onSecurityIndexHealthChange(ClusterIndexHealth previousHealth, ClusterIndexHealth currentHealth) {
        boolean indexDeleted;
        boolean movedFromRedToNonRed = (previousHealth == null || previousHealth.getStatus() == ClusterHealthStatus.RED) && currentHealth != null && currentHealth.getStatus() != ClusterHealthStatus.RED;
        boolean bl = indexDeleted = previousHealth != null && currentHealth == null;
        if (movedFromRedToNonRed || indexDeleted) {
            this.clearCache();
        }
    }

    void clearCache() {
        this.expireAll();
    }

    public static Set<Setting<?>> getSettings() {
        return CachingUsernamePasswordRealm.getCachingSettings();
    }
}

