/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.security.authc.TokenService;

public final class TokenMetaData
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "security_tokens";
    final List<TokenService.KeyAndTimestamp> keys;
    final byte[] currentKeyHash;

    TokenMetaData(List<TokenService.KeyAndTimestamp> keys, byte[] currentKeyHash) {
        this.keys = keys;
        this.currentKeyHash = currentKeyHash;
    }

    public TokenMetaData(StreamInput input) throws IOException {
        this.currentKeyHash = input.readByteArray();
        this.keys = Collections.unmodifiableList(input.readList(TokenService.KeyAndTimestamp::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.currentKeyHash);
        out.writeList(this.keys);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return TokenMetaData.readDiffFrom(ClusterState.Custom.class, (String)TYPE, (StreamInput)in);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TokenMetaData that = (TokenMetaData)((Object)o);
        return this.keys.equals(that.keys) && this.currentKeyHash.equals(that.currentKeyHash);
    }

    public int hashCode() {
        int result = this.keys.hashCode();
        result = 31 * result + this.currentKeyHash.hashCode();
        return result;
    }

    public String toString() {
        return "TokenMetaData{ everything is secret }";
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_0_0_beta2;
    }

    public boolean isPrivate() {
        return true;
    }
}

