/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.time.Instant;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.security.authc.TokenService;

final class ExpiredTokenRemover
extends AbstractRunnable {
    private final Client client;
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    private final Logger logger;
    private final TimeValue timeout;

    ExpiredTokenRemover(Settings settings, Client client) {
        this.client = client;
        this.logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (Settings)settings, (String[])new String[0]);
        this.timeout = (TimeValue)TokenService.DELETE_TIMEOUT.get(settings);
    }

    public void doRun() {
        SearchRequest searchRequest = new SearchRequest(new String[]{".security"});
        DeleteByQueryRequest dbq = new DeleteByQueryRequest(searchRequest);
        if (this.timeout != TimeValue.MINUS_ONE) {
            dbq.setTimeout(this.timeout);
            searchRequest.source().timeout(this.timeout);
        }
        searchRequest.source().query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"doc_type", (String)"invalidated-token")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"expiration_time").lte((Object)Instant.now().toEpochMilli())));
        ClientHelper.executeAsyncWithOrigin(this.client, "security", DeleteByQueryAction.INSTANCE, dbq, ActionListener.wrap(r -> {
            this.debugDbqResponse((BulkByScrollResponse)r);
            this.markComplete();
        }, e -> {
            if (!TransportActions.isShardNotAvailableException((Throwable)e)) {
                this.logger.error("failed to delete expired tokens", (Throwable)e);
            }
            this.markComplete();
        }));
    }

    void submit(ThreadPool threadPool) {
        if (this.inProgress.compareAndSet(false, true)) {
            threadPool.executor("generic").submit((Runnable)((Object)this));
        }
    }

    private void debugDbqResponse(BulkByScrollResponse response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("delete by query of tokens finished with [{}] deletions, [{}] bulk failures, [{}] search failures", (Object)response.getDeleted(), (Object)response.getBulkFailures().size(), (Object)response.getSearchFailures().size());
            for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
                this.logger.debug((Message)new ParameterizedMessage("deletion failed for index [{}], type [{}], id [{}]", new Object[]{failure.getIndex(), failure.getType(), failure.getId()}), (Throwable)failure.getCause());
            }
            for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
                this.logger.debug((Message)new ParameterizedMessage("search failed for index [{}], shard [{}] on node [{}]", new Object[]{failure.getIndex(), failure.getShardId(), failure.getNodeId()}), failure.getReason());
            }
        }
    }

    boolean isExpirationInProgress() {
        return this.inProgress.get();
    }

    public void onFailure(Exception e) {
        this.logger.error("failed to delete expired tokens", (Throwable)e);
        this.markComplete();
    }

    private void markComplete() {
        if (!this.inProgress.compareAndSet(true, false)) {
            throw new IllegalStateException("in progress was set to false but should have been true!");
        }
    }
}

