/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.SecurityContext;
import org.elasticsearch.xpack.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.security.user.SystemUser;
import org.elasticsearch.xpack.security.user.User;
import org.elasticsearch.xpack.security.user.XPackUser;

public class TransportAuthenticateAction
extends HandledTransportAction<AuthenticateRequest, AuthenticateResponse> {
    private final SecurityContext securityContext;

    @Inject
    public TransportAuthenticateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, SecurityContext securityContext) {
        super(settings, "cluster:admin/xpack/security/user/authenticate", threadPool, transportService, actionFilters, indexNameExpressionResolver, AuthenticateRequest::new);
        this.securityContext = securityContext;
    }

    protected void doExecute(AuthenticateRequest request, ActionListener<AuthenticateResponse> listener) {
        User authUser;
        User runAsUser = this.securityContext.getUser();
        User user = authUser = runAsUser == null ? null : runAsUser.authenticatedUser();
        if (authUser == null) {
            listener.onFailure((Exception)new ElasticsearchSecurityException("did not find an authenticated user", new Object[0]));
        } else if (SystemUser.is(authUser) || XPackUser.is(authUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + authUser.principal() + "] is internal"));
        } else if (SystemUser.is(runAsUser) || XPackUser.is(runAsUser)) {
            listener.onFailure((Exception)new IllegalArgumentException("user [" + runAsUser.principal() + "] is internal"));
        } else {
            listener.onResponse((Object)new AuthenticateResponse(runAsUser));
        }
    }
}

