/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.io.IOException;
import java.nio.CharBuffer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.WriteRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.xcontent.XContentUtils;
import org.elasticsearch.xpack.security.action.user.ChangePasswordAction;
import org.elasticsearch.xpack.security.action.user.ChangePasswordRequest;
import org.elasticsearch.xpack.security.action.user.ChangePasswordResponse;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.support.Validation;
import org.elasticsearch.xpack.security.user.User;

public class ChangePasswordRequestBuilder
extends ActionRequestBuilder<ChangePasswordRequest, ChangePasswordResponse, ChangePasswordRequestBuilder>
implements WriteRequestBuilder<ChangePasswordRequestBuilder> {
    public ChangePasswordRequestBuilder(ElasticsearchClient client) {
        super(client, (Action)ChangePasswordAction.INSTANCE, (ActionRequest)new ChangePasswordRequest());
    }

    public ChangePasswordRequestBuilder username(String username) {
        ((ChangePasswordRequest)this.request).username(username);
        return this;
    }

    public static char[] validateAndHashPassword(SecureString password) {
        Validation.Error error = Validation.Users.validatePassword(password.getChars());
        if (error != null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError(error.toString());
            throw validationException;
        }
        return Hasher.BCRYPT.hash(password);
    }

    public ChangePasswordRequestBuilder password(char[] password) {
        try (SecureString secureString = new SecureString(password);){
            char[] hash = ChangePasswordRequestBuilder.validateAndHashPassword(secureString);
            ((ChangePasswordRequest)this.request).passwordHash(hash);
        }
        return this;
    }

    public ChangePasswordRequestBuilder source(BytesReference source, XContentType xContentType) throws IOException {
        try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, source);){
            XContentParser.Token token;
            XContentUtils.verifyObject(parser);
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (User.Fields.PASSWORD.match(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        String password = parser.text();
                        char[] passwordChars = password.toCharArray();
                        this.password(passwordChars);
                        assert (CharBuffer.wrap(passwordChars).chars().noneMatch(i -> (char)i != '\u0000')) : "expected password to clear the char[] but it did not!";
                        continue;
                    }
                    throw new ElasticsearchParseException("expected field [{}] to be of type string, but found [{}] instead", new Object[]{currentFieldName, token});
                }
                throw new ElasticsearchParseException("failed to parse change password request. unexpected field [{}]", new Object[]{currentFieldName});
            }
        }
        return this;
    }
}

