/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenRequest;
import org.elasticsearch.xpack.security.action.token.InvalidateTokenResponse;
import org.elasticsearch.xpack.security.authc.TokenService;

public final class TransportInvalidateTokenAction
extends HandledTransportAction<InvalidateTokenRequest, InvalidateTokenResponse> {
    private final TokenService tokenService;

    @Inject
    public TransportInvalidateTokenAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TokenService tokenService) {
        super(settings, "cluster:admin/xpack/security/token/invalidate", threadPool, transportService, actionFilters, indexNameExpressionResolver, InvalidateTokenRequest::new);
        this.tokenService = tokenService;
    }

    protected void doExecute(InvalidateTokenRequest request, ActionListener<InvalidateTokenResponse> listener) {
        this.tokenService.invalidateToken(request.getTokenString(), (ActionListener<Boolean>)ActionListener.wrap(created -> listener.onResponse((Object)new InvalidateTokenResponse((boolean)created)), arg_0 -> listener.onFailure(arg_0)));
    }
}

