/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.audit.AuditTrailService;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.support.Exceptions;
import org.elasticsearch.xpack.security.user.User;

public final class ResizeRequestInterceptor
extends AbstractComponent
implements RequestInterceptor<ResizeRequest> {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;
    private final AuditTrailService auditTrailService;

    public ResizeRequestInterceptor(Settings settings, ThreadPool threadPool, XPackLicenseState licenseState, AuditTrailService auditTrailService) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
        this.auditTrailService = auditTrailService;
    }

    @Override
    public void intercept(ResizeRequest request, User user, Role userPermissions, String action) {
        IndicesAccessControl indicesAccessControl;
        IndicesAccessControl.IndexAccessControl indexAccessControl;
        if (this.licenseState.isDocumentAndFieldLevelSecurityAllowed() && (indexAccessControl = (indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions")).getIndexPermissions(request.getSourceIndex())) != null) {
            boolean dls;
            boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
            boolean bl = dls = indexAccessControl.getQueries() != null;
            if (fls || dls) {
                throw new ElasticsearchSecurityException("Resize requests are not allowed for users when field or document level security is enabled on the source index", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        Automaton sourceIndexPermissions = userPermissions.indices().allowedActionsMatcher(request.getSourceIndex());
        Automaton targetIndexPermissions = userPermissions.indices().allowedActionsMatcher(request.getTargetIndexRequest().index());
        if (!Operations.subsetOf((Automaton)targetIndexPermissions, (Automaton)sourceIndexPermissions)) {
            this.auditTrailService.accessDenied(user, action, (TransportMessage)request);
            throw Exceptions.authorizationError("Resizing an index is not allowed when the target index has more permissions than the source index", new Object[0]);
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof ResizeRequest;
    }
}

