/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.interceptor;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.action.interceptor.RequestInterceptor;
import org.elasticsearch.xpack.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.security.authz.permission.Role;
import org.elasticsearch.xpack.security.user.User;

public class BulkShardRequestInterceptor
extends AbstractComponent
implements RequestInterceptor<BulkShardRequest> {
    private final ThreadContext threadContext;
    private final XPackLicenseState licenseState;

    public BulkShardRequestInterceptor(Settings settings, ThreadPool threadPool, XPackLicenseState licenseState) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.licenseState = licenseState;
    }

    @Override
    public void intercept(BulkShardRequest request, User user, Role userPermissions, String action) {
        if (!this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            return;
        }
        IndicesAccessControl indicesAccessControl = (IndicesAccessControl)this.threadContext.getTransient("_indices_permissions");
        for (BulkItemRequest bulkItemRequest : request.items()) {
            IndicesAccessControl.IndexAccessControl indexAccessControl = indicesAccessControl.getIndexPermissions(bulkItemRequest.index());
            if (indexAccessControl != null) {
                boolean dls;
                boolean fls = indexAccessControl.getFieldPermissions().hasFieldLevelSecurity();
                boolean bl = dls = indexAccessControl.getQueries() != null;
                if ((fls || dls) && bulkItemRequest.request() instanceof UpdateRequest) {
                    throw new ElasticsearchSecurityException("Can't execute a bulk request with update requests embedded if field or document level security is enabled", RestStatus.BAD_REQUEST, new Object[0]);
                }
            }
            this.logger.trace("intercepted bulk request for index [{}] without any update requests, continuing execution", (Object)bulkItemRequest.index());
        }
    }

    @Override
    public boolean supports(TransportRequest request) {
        return request instanceof BulkShardRequest;
    }
}

