/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.index.IndexAuditTrail;
import org.elasticsearch.xpack.security.support.IndexLifecycleManager;

public class SecurityLifecycleService
extends AbstractComponent
implements ClusterStateListener {
    public static final String SECURITY_INDEX_NAME = ".security";
    public static final String SECURITY_TEMPLATE_NAME = "security-index-template";
    public static final String INTERNAL_SECURITY_INDEX = ".security-6";
    private static final Version MIN_READ_VERSION = Version.V_5_0_0;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final IndexAuditTrail indexAuditTrail;
    private final IndexLifecycleManager securityIndex;

    public SecurityLifecycleService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client, @Nullable IndexAuditTrail indexAuditTrail) {
        super(settings);
        this.settings = settings;
        this.threadPool = threadPool;
        this.indexAuditTrail = indexAuditTrail;
        this.securityIndex = new IndexLifecycleManager(settings, client, SECURITY_INDEX_NAME, SECURITY_TEMPLATE_NAME);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.addLifecycleListener(new LifecycleListener(){

            public void beforeStop() {
                SecurityLifecycleService.this.close();
            }
        });
    }

    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            this.logger.debug("lifecycle service waiting until state has been recovered");
            return;
        }
        this.securityIndex.clusterChanged(event);
        try {
            if (Security.indexAuditLoggingEnabled(this.settings) && this.indexAuditTrail.state() == IndexAuditTrail.State.INITIALIZED && this.indexAuditTrail.canStart(event)) {
                this.threadPool.generic().execute((Runnable)new AbstractRunnable(){

                    public void onFailure(Exception throwable) {
                        SecurityLifecycleService.this.logger.error("failed to start index audit trail services", (Throwable)throwable);
                        assert (false) : "security lifecycle services startup failed";
                    }

                    public void doRun() {
                        SecurityLifecycleService.this.indexAuditTrail.start();
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("failed to start index audit trail", (Throwable)e);
        }
    }

    IndexLifecycleManager securityIndex() {
        return this.securityIndex;
    }

    public boolean isSecurityIndexExisting() {
        return this.securityIndex.indexExists();
    }

    public boolean isSecurityIndexUpToDate() {
        return this.securityIndex.isIndexUpToDate();
    }

    public boolean isSecurityIndexAvailable() {
        return this.securityIndex.isAvailable();
    }

    public boolean isSecurityIndexWriteable() {
        return this.securityIndex.isWritable();
    }

    public boolean checkSecurityMappingVersion(Predicate<Version> requiredVersion) {
        return this.securityIndex.checkMappingVersion(requiredVersion);
    }

    public void addSecurityIndexHealthChangeListener(BiConsumer<ClusterIndexHealth, ClusterIndexHealth> listener) {
        this.securityIndex.addIndexHealthChangeListener(listener);
    }

    void addSecurityIndexOutOfDateListener(BiConsumer<Boolean, Boolean> listener) {
        this.securityIndex.addIndexOutOfDateListener(listener);
    }

    private void close() {
        if (this.indexAuditTrail != null) {
            try {
                this.indexAuditTrail.stop();
            }
            catch (Exception e) {
                this.logger.error("failed to stop audit trail module", (Throwable)e);
            }
        }
    }

    public static boolean securityIndexMappingAndTemplateSufficientToRead(ClusterState clusterState, Logger logger) {
        return SecurityLifecycleService.checkTemplateAndMappingVersions(clusterState, logger, arg_0 -> ((Version)MIN_READ_VERSION).onOrBefore(arg_0));
    }

    public static boolean securityIndexMappingAndTemplateUpToDate(ClusterState clusterState, Logger logger) {
        return SecurityLifecycleService.checkTemplateAndMappingVersions(clusterState, logger, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private static boolean checkTemplateAndMappingVersions(ClusterState clusterState, Logger logger, Predicate<Version> versionPredicate) {
        return IndexLifecycleManager.checkTemplateExistsAndVersionMatches(SECURITY_TEMPLATE_NAME, clusterState, logger, versionPredicate) && IndexLifecycleManager.checkIndexMappingVersionMatches(SECURITY_INDEX_NAME, clusterState, logger, versionPredicate);
    }

    public static List<String> indexNames() {
        return Collections.unmodifiableList(Arrays.asList(SECURITY_INDEX_NAME, INTERNAL_SECURITY_INDEX));
    }

    public <T> void createIndexIfNeededThenExecute(ActionListener<T> listener, Runnable andThen) {
        if (!this.isSecurityIndexExisting() || this.isSecurityIndexUpToDate()) {
            this.securityIndex.createIndexIfNeededThenExecute(listener, andThen);
        } else {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
        }
    }

    public boolean isSecurityIndexOutOfDate() {
        return !this.securityIndex.isIndexUpToDate();
    }
}

