/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.util.Map;
import org.elasticsearch.bootstrap.BootstrapCheck;
import org.elasticsearch.bootstrap.BootstrapContext;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.RealmSettings;
import org.elasticsearch.xpack.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.ssl.SSLService;

class PkiRealmBootstrapCheck
implements BootstrapCheck {
    private final SSLService sslService;

    PkiRealmBootstrapCheck(SSLService sslService) {
        this.sslService = sslService;
    }

    public BootstrapCheck.BootstrapCheckResult check(BootstrapContext context) {
        Settings settings = context.settings;
        boolean pkiRealmEnabled = settings.getGroups(RealmSettings.PREFIX).values().stream().filter(s -> "pki".equals(s.get("type"))).anyMatch(s -> s.getAsBoolean("enabled", Boolean.valueOf(true)));
        if (pkiRealmEnabled) {
            boolean httpSsl = (Boolean)XPackSettings.HTTP_SSL_ENABLED.get(settings);
            Settings httpSSLSettings = SSLService.getHttpTransportSSLSettings(settings);
            boolean httpClientAuth = this.sslService.isSSLClientAuthEnabled(httpSSLSettings);
            if (httpSsl && httpClientAuth) {
                return BootstrapCheck.BootstrapCheckResult.success();
            }
            boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
            Settings transportSSLSettings = settings.getByPrefix(Security.setting("transport.ssl."));
            boolean clientAuthEnabled = this.sslService.isSSLClientAuthEnabled(transportSSLSettings);
            if (transportSSLEnabled && clientAuthEnabled) {
                return BootstrapCheck.BootstrapCheckResult.success();
            }
            Map groupedSettings = settings.getGroups("transport.profiles.");
            for (Map.Entry entry : groupedSettings.entrySet()) {
                if (!transportSSLEnabled || !this.sslService.isSSLClientAuthEnabled(SecurityNetty4Transport.profileSslSettings((Settings)entry.getValue()), transportSSLSettings)) continue;
                return BootstrapCheck.BootstrapCheckResult.success();
            }
            return BootstrapCheck.BootstrapCheckResult.failure((String)"a PKI realm is enabled but cannot be used as neither HTTP or Transport have SSL and client authentication enabled");
        }
        return BootstrapCheck.BootstrapCheckResult.success();
    }

    public boolean alwaysEnforce() {
        return true;
    }
}

