/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.scheduler;

import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public class SchedulerEngine {
    private final Map<String, ActiveSchedule> schedules = ConcurrentCollections.newConcurrentMap();
    private final ScheduledExecutorService scheduler;
    private final Clock clock;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public SchedulerEngine(Clock clock) {
        this.clock = clock;
        this.scheduler = Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory((String)"trigger_engine_scheduler"));
    }

    public void register(Listener listener) {
        this.listeners.add(listener);
    }

    public void start(Collection<Job> jobs) {
        jobs.forEach(this::add);
    }

    public void stop() {
        this.scheduler.shutdownNow();
        try {
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void add(Job job) {
        ActiveSchedule schedule = new ActiveSchedule(job.getId(), job.getSchedule(), this.clock.millis());
        this.schedules.compute(schedule.name, (name, previousSchedule) -> {
            if (previousSchedule != null) {
                previousSchedule.cancel();
            }
            return schedule;
        });
    }

    public boolean remove(String jobId) {
        ActiveSchedule removedSchedule = this.schedules.remove(jobId);
        if (removedSchedule != null) {
            removedSchedule.cancel();
        }
        return removedSchedule != null;
    }

    public int jobCount() {
        return this.schedules.size();
    }

    protected void notifyListeners(String name, long triggeredTime, long scheduledTime) {
        Event event = new Event(name, triggeredTime, scheduledTime);
        for (Listener listener : this.listeners) {
            listener.triggered(event);
        }
    }

    class ActiveSchedule
    implements Runnable {
        private final String name;
        private final Schedule schedule;
        private final long startTime;
        private volatile ScheduledFuture<?> future;
        private volatile long scheduledTime;

        ActiveSchedule(String name, Schedule schedule, long startTime) {
            this.name = name;
            this.schedule = schedule;
            this.startTime = startTime;
            this.scheduleNextRun(startTime);
        }

        @Override
        public void run() {
            long triggeredTime = SchedulerEngine.this.clock.millis();
            SchedulerEngine.this.notifyListeners(this.name, triggeredTime, this.scheduledTime);
            this.scheduleNextRun(triggeredTime);
        }

        private void scheduleNextRun(long currentTime) {
            this.scheduledTime = this.schedule.nextScheduledTimeAfter(this.startTime, currentTime);
            if (this.scheduledTime != -1L) {
                long delay = Math.max(0L, this.scheduledTime - currentTime);
                this.future = SchedulerEngine.this.scheduler.schedule(this, delay, TimeUnit.MILLISECONDS);
            }
        }

        public void cancel() {
            FutureUtils.cancel(this.future);
        }
    }

    public static interface Schedule {
        public long nextScheduledTimeAfter(long var1, long var3);
    }

    public static interface Listener {
        public void triggered(Event var1);
    }

    public static class Event {
        private final String jobName;
        private final long triggeredTime;
        private final long scheduledTime;

        public Event(String jobName, long triggeredTime, long scheduledTime) {
            this.jobName = jobName;
            this.triggeredTime = triggeredTime;
            this.scheduledTime = scheduledTime;
        }

        public String getJobName() {
            return this.jobName;
        }

        public long getTriggeredTime() {
            return this.triggeredTime;
        }

        public long getScheduledTime() {
            return this.scheduledTime;
        }
    }

    public static class Job {
        private final String id;
        private final Schedule schedule;

        public Job(String id, Schedule schedule) {
            this.id = id;
            this.schedule = schedule;
        }

        public String getId() {
            return this.id;
        }

        public Schedule getSchedule() {
            return this.schedule;
        }
    }
}

