/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.persistent;

import java.util.function.Predicate;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksRequest;
import org.elasticsearch.action.admin.cluster.node.tasks.cancel.CancelTasksResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ClientHelper;
import org.elasticsearch.xpack.persistent.CompletionPersistentTaskAction;
import org.elasticsearch.xpack.persistent.PersistentTaskParams;
import org.elasticsearch.xpack.persistent.PersistentTasksCustomMetaData;
import org.elasticsearch.xpack.persistent.RemovePersistentTaskAction;
import org.elasticsearch.xpack.persistent.StartPersistentTaskAction;
import org.elasticsearch.xpack.persistent.UpdatePersistentTaskStatusAction;

public class PersistentTasksService
extends AbstractComponent {
    private final Client client;
    private final ClusterService clusterService;
    private final ThreadPool threadPool;

    public PersistentTasksService(Settings settings, ClusterService clusterService, ThreadPool threadPool, Client client) {
        super(settings);
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void startPersistentTask(String taskId, String taskName, @Nullable Params params, ActionListener<PersistentTasksCustomMetaData.PersistentTask<Params>> listener) {
        StartPersistentTaskAction.Request createPersistentActionRequest = new StartPersistentTaskAction.Request(taskId, taskName, params);
        try {
            ClientHelper.executeAsyncWithOrigin(this.client, "persistent_tasks", StartPersistentTaskAction.INSTANCE, createPersistentActionRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void sendCompletionNotification(String taskId, long allocationId, Exception failure, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        CompletionPersistentTaskAction.Request restartRequest = new CompletionPersistentTaskAction.Request(taskId, allocationId, failure);
        try {
            ClientHelper.executeAsyncWithOrigin(this.client, "persistent_tasks", CompletionPersistentTaskAction.INSTANCE, restartRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void sendTaskManagerCancellation(long taskId, ActionListener<CancelTasksResponse> listener) {
        DiscoveryNode localNode = this.clusterService.localNode();
        CancelTasksRequest cancelTasksRequest = new CancelTasksRequest();
        cancelTasksRequest.setTaskId(new TaskId(localNode.getId(), taskId));
        cancelTasksRequest.setReason("persistent action was removed");
        try {
            ClientHelper.executeAsyncWithOrigin(this.client.threadPool().getThreadContext(), "persistent_tasks", cancelTasksRequest, listener, (arg_0, arg_1) -> ((ClusterAdminClient)this.client.admin().cluster()).cancelTasks(arg_0, arg_1));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    void updateStatus(String taskId, long allocationId, Task.Status status, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        UpdatePersistentTaskStatusAction.Request updateStatusRequest = new UpdatePersistentTaskStatusAction.Request(taskId, allocationId, status);
        try {
            ClientHelper.executeAsyncWithOrigin(this.client, "persistent_tasks", UpdatePersistentTaskStatusAction.INSTANCE, updateStatusRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void cancelPersistentTask(String taskId, ActionListener<PersistentTasksCustomMetaData.PersistentTask<?>> listener) {
        RemovePersistentTaskAction.Request removeRequest = new RemovePersistentTaskAction.Request(taskId);
        try {
            ClientHelper.executeAsyncWithOrigin(this.client, "persistent_tasks", RemovePersistentTaskAction.INSTANCE, removeRequest, ActionListener.wrap(o -> listener.onResponse(o.getTask()), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public void waitForPersistentTaskStatus(final String taskId, Predicate<PersistentTasksCustomMetaData.PersistentTask<?>> predicate, @Nullable TimeValue timeout, final WaitForPersistentTaskStatusListener<?> listener) {
        ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
        if (predicate.test(PersistentTasksCustomMetaData.getTaskWithId(stateObserver.setAndGetObservedState(), taskId))) {
            listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(stateObserver.setAndGetObservedState(), taskId));
        } else {
            stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    listener.onResponse(PersistentTasksCustomMetaData.getTaskWithId(state, taskId));
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onTimeout(timeout);
                }
            }, clusterState -> predicate.test(PersistentTasksCustomMetaData.getTaskWithId(clusterState, taskId)));
        }
    }

    public void waitForPersistentTasksStatus(Predicate<PersistentTasksCustomMetaData> predicate, @Nullable TimeValue timeout, final ActionListener<Boolean> listener) {
        ClusterStateObserver stateObserver = new ClusterStateObserver(this.clusterService, timeout, this.logger, this.threadPool.getThreadContext());
        if (predicate.test((PersistentTasksCustomMetaData)stateObserver.setAndGetObservedState().metaData().custom("persistent_tasks"))) {
            listener.onResponse((Object)true);
        } else {
            stateObserver.waitForNextChange(new ClusterStateObserver.Listener(){

                public void onNewClusterState(ClusterState state) {
                    listener.onResponse((Object)true);
                }

                public void onClusterServiceClose() {
                    listener.onFailure((Exception)new NodeClosedException(PersistentTasksService.this.clusterService.localNode()));
                }

                public void onTimeout(TimeValue timeout) {
                    listener.onFailure((Exception)new IllegalStateException("timed out after " + timeout));
                }
            }, clusterState -> predicate.test((PersistentTasksCustomMetaData)clusterState.metaData().custom("persistent_tasks")), timeout);
        }
    }

    public static interface WaitForPersistentTaskStatusListener<Params extends PersistentTaskParams>
    extends ActionListener<PersistentTasksCustomMetaData.PersistentTask<Params>> {
        default public void onTimeout(TimeValue timeout) {
            this.onFailure(new IllegalStateException("timed out after " + timeout));
        }
    }
}

