/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.jira;

import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.notification.NotificationService;
import org.elasticsearch.xpack.notification.jira.JiraAccount;

public class JiraService
extends NotificationService<JiraAccount> {
    public static final Setting<Settings> JIRA_ACCOUNT_SETTING = Setting.groupSetting((String)"xpack.notification.jira.", (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final HttpClient httpClient;

    public JiraService(Settings settings, HttpClient httpClient, ClusterSettings clusterSettings) {
        super(settings, "jira");
        this.httpClient = httpClient;
        clusterSettings.addSettingsUpdateConsumer(JIRA_ACCOUNT_SETTING, this::setAccountSetting);
        this.setAccountSetting((Settings)JIRA_ACCOUNT_SETTING.get(settings));
    }

    @Override
    protected JiraAccount createAccount(String name, Settings accountSettings) {
        return new JiraAccount(name, accountSettings, this.httpClient);
    }
}

