/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.jira;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpMethod;
import org.elasticsearch.xpack.common.http.HttpProxy;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.common.http.Scheme;
import org.elasticsearch.xpack.common.http.auth.basic.BasicAuth;
import org.elasticsearch.xpack.notification.jira.JiraIssue;

public class JiraAccount {
    public static final String DEFAULT_PATH = "/rest/api/2/issue";
    static final String USER_SETTING = "user";
    static final String PASSWORD_SETTING = "password";
    static final String URL_SETTING = "url";
    static final String ISSUE_DEFAULTS_SETTING = "issue_defaults";
    static final String ALLOW_HTTP_SETTING = "allow_http";
    private final HttpClient httpClient;
    private final String name;
    private final String user;
    private final String password;
    private final URI url;
    private final Map<String, Object> issueDefaults;

    public JiraAccount(String name, Settings settings, HttpClient httpClient) {
        this.httpClient = httpClient;
        this.name = name;
        String url = settings.get(URL_SETTING);
        if (url == null) {
            throw JiraAccount.requiredSettingException(name, URL_SETTING);
        }
        try {
            URI uri = new URI(url);
            Scheme protocol = Scheme.parse(uri.getScheme());
            if (protocol == Scheme.HTTP && !Booleans.isTrue((String)settings.get(ALLOW_HTTP_SETTING))) {
                throw new SettingsException("invalid jira [" + name + "] account settings. unsecure scheme [" + (Object)((Object)protocol) + "]");
            }
            this.url = uri;
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            throw new SettingsException("invalid jira [" + name + "] account settings. invalid [" + URL_SETTING + "] setting", (Throwable)e);
        }
        this.user = settings.get(USER_SETTING);
        if (Strings.isEmpty((CharSequence)this.user)) {
            throw JiraAccount.requiredSettingException(name, USER_SETTING);
        }
        this.password = settings.get(PASSWORD_SETTING);
        if (Strings.isEmpty((CharSequence)this.password)) {
            throw JiraAccount.requiredSettingException(name, PASSWORD_SETTING);
        }
        try (XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());){
            builder.startObject();
            settings.getAsSettings(ISSUE_DEFAULTS_SETTING).toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            this.issueDefaults = Collections.unmodifiableMap(XContentType.JSON.xContent().createParser(new NamedXContentRegistry(Collections.emptyList()), builder.bytes()).map());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getDefaults() {
        return this.issueDefaults;
    }

    public JiraIssue createIssue(Map<String, Object> fields, HttpProxy proxy) throws IOException {
        HttpRequest request = HttpRequest.builder(this.url.getHost(), this.url.getPort()).scheme(Scheme.parse(this.url.getScheme())).method(HttpMethod.POST).path(this.url.getPath().isEmpty() || this.url.getPath().equals("/") ? DEFAULT_PATH : this.url.getPath()).jsonBody((builder, params) -> builder.field("fields", fields)).auth(new BasicAuth(this.user, this.password.toCharArray())).proxy(proxy).build();
        HttpResponse response = this.httpClient.execute(request);
        return JiraIssue.responded(this.name, fields, request, response);
    }

    private static SettingsException requiredSettingException(String account, String setting) {
        return new SettingsException("invalid jira [" + account + "] account settings. missing required [" + setting + "] setting");
    }
}

