/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email.attachment;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.notification.email.Attachment;
import org.elasticsearch.xpack.notification.email.DataAttachment;
import org.elasticsearch.xpack.notification.email.attachment.EmailAttachmentParser;
import org.elasticsearch.xpack.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.watcher.support.Variables;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class DataAttachmentParser
implements EmailAttachmentParser<org.elasticsearch.xpack.notification.email.attachment.DataAttachment> {
    public static final String TYPE = "data";

    @Override
    public String type() {
        return TYPE;
    }

    @Override
    public org.elasticsearch.xpack.notification.email.attachment.DataAttachment parse(String id, XContentParser parser) throws IOException {
        XContentParser.Token token;
        DataAttachment dataAttachment = DataAttachment.YAML;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!Strings.hasLength(currentFieldName) || !Fields.FORMAT.match(currentFieldName)) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                dataAttachment = DataAttachment.resolve(parser.text());
                continue;
            }
            throw new ElasticsearchParseException("could not parse data attachment. expected string value for [{}] field but found [{}] instead", new Object[]{currentFieldName, token});
        }
        return new org.elasticsearch.xpack.notification.email.attachment.DataAttachment(id, dataAttachment);
    }

    @Override
    public Attachment toAttachment(WatchExecutionContext ctx, Payload payload, org.elasticsearch.xpack.notification.email.attachment.DataAttachment attachment) throws IOException {
        Map<String, Object> model = Variables.createCtxModel(ctx, payload);
        return attachment.getDataAttachment().create(attachment.id(), model);
    }

    static interface Fields {
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

