/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.email;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.settings.Settings;
import org.owasp.html.CssSchema;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public class HtmlSanitizer {
    static final String[] FORMATTING_TAGS = new String[]{"b", "i", "s", "u", "o", "sup", "sub", "ins", "del", "strong", "strike", "tt", "code", "big", "small", "br", "span", "em", "hr"};
    static final String[] BLOCK_TAGS = new String[]{"p", "div", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "li", "blockquote"};
    static final String[] TABLE_TAGS = new String[]{"table", "th", "tr", "td", "caption", "col", "colgroup", "thead", "tbody", "tfoot"};
    static final List<String> DEFAULT_ALLOWED = Arrays.asList("body", "head", "_tables", "_links", "_blocks", "_formatting", "img:embedded");
    private final boolean enabled;
    @SuppressForbidden(reason="PolicyFactory uses guava Function")
    private final PolicyFactory policy;

    public HtmlSanitizer(Settings settings) {
        this.enabled = settings.getAsBoolean("xpack.notification.email.html.sanitization.enabled", Boolean.valueOf(true));
        List allow = settings.getAsList("xpack.notification.email.html.sanitization.allow", DEFAULT_ALLOWED);
        List disallow = settings.getAsList("xpack.notification.email.html.sanitization.disallow");
        this.policy = HtmlSanitizer.createCommonPolicy(allow, disallow);
    }

    public String sanitize(String html) {
        if (!this.enabled) {
            return html;
        }
        return this.policy.sanitize(html);
    }

    @SuppressForbidden(reason="PolicyFactory uses guava Function")
    static PolicyFactory createCommonPolicy(List<String> allow, List<String> disallow) {
        HtmlPolicyBuilder policyBuilder = new HtmlPolicyBuilder();
        if (allow.stream().anyMatch("_all"::equals)) {
            return policyBuilder.allowElements(TABLE_TAGS).allowAttributes(new String[]{"span"}).onElements(new String[]{"col"}).allowElements(BLOCK_TAGS).allowElements(FORMATTING_TAGS).allowWithoutAttributes(new String[]{"span"}).allowStyling(CssSchema.DEFAULT).allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).requireRelNofollowOnLinks().allowElements(new String[]{"img"}).allowAttributes(new String[]{"src"}).onElements(new String[]{"img"}).allowStandardUrlProtocols().allowUrlProtocols(new String[]{"cid"}).toFactory();
        }
        EnumSet<Images> images = EnumSet.noneOf(Images.class);
        block38: for (String tag : allow) {
            switch (tag = tag.toLowerCase(Locale.ROOT)) {
                case "_tables": {
                    policyBuilder.allowElements(TABLE_TAGS);
                    policyBuilder.allowAttributes(new String[]{"span"}).onElements(new String[]{"col"});
                    policyBuilder.allowAttributes(new String[]{"border", "cellpadding"}).onElements(new String[]{"table"});
                    policyBuilder.allowAttributes(new String[]{"colspan", "rowspan"}).onElements(new String[]{"th", "td"});
                    continue block38;
                }
                case "_links": {
                    policyBuilder.allowElements(new String[]{"a"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).allowStandardUrlProtocols().requireRelNofollowOnLinks();
                    continue block38;
                }
                case "_blocks": {
                    policyBuilder.allowElements(BLOCK_TAGS);
                    continue block38;
                }
                case "_formatting": {
                    policyBuilder.allowElements(FORMATTING_TAGS).allowWithoutAttributes(new String[]{"span"});
                    continue block38;
                }
                case "_styles": {
                    policyBuilder.allowStyling(CssSchema.DEFAULT);
                    continue block38;
                }
                case "img:all": 
                case "img": {
                    images.add(Images.ALL);
                    continue block38;
                }
                case "img:embedded": {
                    images.add(Images.EMBEDDED);
                    continue block38;
                }
            }
            policyBuilder.allowElements(new String[]{tag});
        }
        block39: for (String tag : disallow) {
            switch (tag = tag.toLowerCase(Locale.ROOT)) {
                case "_tables": {
                    policyBuilder.disallowElements(TABLE_TAGS);
                    continue block39;
                }
                case "_links": {
                    policyBuilder.disallowElements(new String[]{"a"});
                    continue block39;
                }
                case "_blocks": {
                    policyBuilder.disallowElements(BLOCK_TAGS);
                    continue block39;
                }
                case "_formatting": {
                    policyBuilder.disallowElements(FORMATTING_TAGS);
                    continue block39;
                }
                case "_styles": {
                    policyBuilder.disallowAttributes(new String[]{"style"});
                    continue block39;
                }
                case "img:all": 
                case "img": {
                    images.remove((Object)Images.ALL);
                    continue block39;
                }
                case "img:embedded": {
                    images.remove((Object)Images.EMBEDDED);
                    continue block39;
                }
            }
            policyBuilder.disallowElements(new String[]{tag});
        }
        if (!images.isEmpty()) {
            policyBuilder.allowAttributes(new String[]{"src"}).onElements(new String[]{"img"}).allowUrlProtocols(new String[]{"cid"});
            if (images.contains((Object)Images.ALL)) {
                policyBuilder.allowElements(new String[]{"img"});
                policyBuilder.allowStandardUrlProtocols();
            } else {
                policyBuilder.allowElements((ElementPolicy)EmbeddedImgOnlyPolicy.INSTANCE, new String[]{"img"});
            }
        }
        return policyBuilder.toFactory();
    }

    static enum Images {
        ALL,
        EMBEDDED;

    }

    private static class EmbeddedImgOnlyPolicy
    implements ElementPolicy {
        private static EmbeddedImgOnlyPolicy INSTANCE = new EmbeddedImgOnlyPolicy();

        private EmbeddedImgOnlyPolicy() {
        }

        public String apply(String elementName, List<String> attrs) {
            if (!"img".equals(elementName) || attrs.size() == 0) {
                return elementName;
            }
            String attrName = null;
            for (String attr : attrs) {
                if (attrName == null) {
                    attrName = attr.toLowerCase(Locale.ROOT);
                    continue;
                }
                if (!"src".equals(attrName) || attr.startsWith("cid:")) continue;
                return null;
            }
            return elementName;
        }
    }
}

