/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class ClusterAlertHttpResource
extends PublishableHttpResource {
    private static final Logger logger = Loggers.getLogger(ClusterAlertHttpResource.class);
    public static final Map<String, String> CLUSTER_ALERT_VERSION_PARAMETERS = Collections.singletonMap("filter_path", "metadata.xpack.version_created");
    private final XPackLicenseState licenseState;
    private final Supplier<String> watchId;
    @Nullable
    private final Supplier<String> watch;

    public ClusterAlertHttpResource(String resourceOwnerName, XPackLicenseState licenseState, Supplier<String> watchId, @Nullable Supplier<String> watch) {
        super(resourceOwnerName, null, CLUSTER_ALERT_VERSION_PARAMETERS);
        this.licenseState = Objects.requireNonNull(licenseState);
        this.watchId = Objects.requireNonNull(watchId);
        this.watch = watch;
    }

    @Override
    protected PublishableHttpResource.CheckResponse doCheck(RestClient client) {
        if (this.isWatchDefined() && this.licenseState.isMonitoringClusterAlertsAllowed()) {
            CheckedFunction watchChecker = response -> this.shouldReplaceClusterAlert((Response)response, XContentType.JSON.xContent(), ClusterAlertsUtil.LAST_UPDATED_VERSION);
            return this.versionCheckForResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster", (CheckedFunction<Response, Boolean, IOException>)watchChecker);
        }
        boolean deleted = this.deleteResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster");
        return deleted ? PublishableHttpResource.CheckResponse.EXISTS : PublishableHttpResource.CheckResponse.ERROR;
    }

    @Override
    protected boolean doPublish(RestClient client) {
        return this.putResource(client, logger, "/_xpack/watcher/watch", this.watchId.get(), this::watchToHttpEntity, "monitoring cluster alert", this.resourceOwnerName, "monitoring cluster");
    }

    boolean isWatchDefined() {
        return this.watch != null;
    }

    HttpEntity watchToHttpEntity() {
        return new StringEntity(this.watch.get(), ContentType.APPLICATION_JSON);
    }

    boolean shouldReplaceClusterAlert(Response response, XContent xContent, int minimumVersion) throws IOException {
        Map resources = XContentHelper.convertToMap((XContent)xContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        if (!resources.isEmpty()) {
            Object version;
            Map metadata = (Map)resources.get("metadata");
            Map xpack = metadata != null ? (Map)metadata.get("xpack") : null;
            Object v0 = version = xpack != null ? xpack.get("version_created") : null;
            if (version instanceof Number) {
                return ((Number)version).intValue() < minimumVersion;
            }
        }
        return true;
    }
}

