/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class BytesReferenceMonitoringDoc
extends MonitoringDoc {
    private final XContentType xContentType;
    private final BytesReference source;

    public BytesReferenceMonitoringDoc(String cluster, long timestamp, long intervalMillis, @Nullable MonitoringDoc.Node node, MonitoredSystem system, String type, @Nullable String id, XContentType xContentType, BytesReference source) {
        super(cluster, timestamp, intervalMillis, node, system, type, id);
        this.xContentType = Objects.requireNonNull(xContentType);
        this.source = Objects.requireNonNull(source);
    }

    XContentType getXContentType() {
        return this.xContentType;
    }

    BytesReference getSource() {
        return this.source;
    }

    @Override
    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source.length() > 0) {
            builder.rawField(this.getType(), this.source, this.xContentType);
        } else {
            builder.nullField(this.getType());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BytesReferenceMonitoringDoc that = (BytesReferenceMonitoringDoc)o;
        return this.xContentType == that.xContentType && Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.xContentType, this.source);
    }
}

