/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.shards;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.monitoring.exporter.FilteredMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class ShardMonitoringDoc
extends FilteredMonitoringDoc {
    public static final String TYPE = "shards";
    private final ShardRouting shardRouting;
    private final String clusterStateUUID;
    public static final Set<String> XCONTENT_FILTERS = Sets.newHashSet((Object[])new String[]{"state_uuid", "shard.state", "shard.primary", "shard.node", "shard.relocating_node", "shard.shard", "shard.index"});

    ShardMonitoringDoc(String cluster, long timestamp, long interval, MonitoringDoc.Node node, ShardRouting shardRouting, String clusterStateUUID) {
        super(cluster, timestamp, interval, node, MonitoredSystem.ES, TYPE, ShardMonitoringDoc.id(clusterStateUUID, shardRouting), XCONTENT_FILTERS);
        this.shardRouting = Objects.requireNonNull(shardRouting);
        this.clusterStateUUID = Objects.requireNonNull(clusterStateUUID);
    }

    ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    String getClusterStateUUID() {
        return this.clusterStateUUID;
    }

    @Override
    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("state_uuid", this.clusterStateUUID);
        if (this.shardRouting != null) {
            builder.field("shard", (ToXContent)this.shardRouting, params);
        }
    }

    public static String id(String stateUUID, ShardRouting shardRouting) {
        StringBuilder builder = new StringBuilder();
        builder.append(stateUUID);
        builder.append(':');
        if (shardRouting.assignedToNode()) {
            builder.append(shardRouting.currentNodeId());
        } else {
            builder.append("_na");
        }
        builder.append(':');
        builder.append(shardRouting.getIndexName());
        builder.append(':');
        builder.append((Object)shardRouting.id());
        builder.append(':');
        if (shardRouting.primary()) {
            builder.append("p");
        } else {
            builder.append("r");
        }
        return builder.toString();
    }
}

