/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.indices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.indices.IndexStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.indices.IndicesStatsMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.FilteredMonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;

public class IndexStatsCollector
extends Collector {
    public static final Setting<TimeValue> INDEX_STATS_TIMEOUT = IndexStatsCollector.collectionTimeoutSetting("index.stats.timeout");
    private final Client client;

    public IndexStatsCollector(Settings settings, ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        super(settings, "index-stats", clusterService, INDEX_STATS_TIMEOUT, licenseState);
        this.client = client;
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return isElectedMaster && super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) throws Exception {
        ArrayList<FilteredMonitoringDoc> results = new ArrayList<FilteredMonitoringDoc>();
        IndicesStatsResponse indicesStats = (IndicesStatsResponse)((IndicesStatsRequestBuilder)((IndicesStatsRequestBuilder)this.client.admin().indices().prepareStats(new String[0]).setIndices(this.getCollectionIndices())).setIndicesOptions(IndicesOptions.lenientExpandOpen())).clear().setDocs(true).setFieldData(true).setIndexing(true).setMerge(true).setSearch(true).setSegments(true).setStore(true).setRefresh(true).setQueryCache(true).setRequestCache(true).get(this.getCollectionTimeout());
        long timestamp = IndexStatsCollector.timestamp();
        String clusterUuid = IndexStatsCollector.clusterUuid(clusterState);
        results.add(new IndicesStatsMonitoringDoc(clusterUuid, timestamp, interval, node, indicesStats));
        for (IndexStats indexStats : indicesStats.getIndices().values()) {
            String index = indexStats.getIndex();
            IndexMetaData metaData = clusterState.metaData().index(index);
            IndexRoutingTable routingTable = clusterState.routingTable().index(index);
            results.add(new IndexStatsMonitoringDoc(clusterUuid, timestamp, interval, node, indexStats, metaData, routingTable));
        }
        return Collections.unmodifiableCollection(results);
    }
}

