/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

public class MonitoringBulkResponse
extends ActionResponse {
    private long tookInMillis;
    private Error error;

    MonitoringBulkResponse() {
    }

    public MonitoringBulkResponse(long tookInMillis) {
        this(tookInMillis, null);
    }

    public MonitoringBulkResponse(long tookInMillis, Error error) {
        this.tookInMillis = tookInMillis;
        this.error = error;
    }

    public TimeValue getTook() {
        return new TimeValue(this.tookInMillis);
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public RestStatus status() {
        return this.error == null ? RestStatus.OK : RestStatus.INTERNAL_SERVER_ERROR;
    }

    public Error getError() {
        return this.error;
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.tookInMillis = in.readVLong();
        this.error = (Error)in.readOptionalWriteable(Error::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.tookInMillis);
        out.writeOptionalWriteable((Writeable)this.error);
    }

    public static class Error
    implements Writeable,
    ToXContentObject {
        private final Throwable cause;
        private final RestStatus status;

        public Error(Throwable t) {
            this.cause = Objects.requireNonNull(t);
            this.status = ExceptionsHelper.status((Throwable)t);
        }

        Error(StreamInput in) throws IOException {
            this(in.readException());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeException(this.getCause());
        }

        public String getMessage() {
            return this.cause.toString();
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Throwable getCause() {
            return this.cause;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.cause);
            builder.endObject();
            return builder;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Error [");
            sb.append("cause=").append(this.cause);
            sb.append(", status=").append(this.status);
            sb.append(']');
            return sb.toString();
        }
    }
}

